/*
 * exec.h: this file is part of the Scoptools project.
 *
 * ScopTools, a set of convenience functions to translate to/from ScopLib.
 *
 * Copyright (C) 2010 Louis-Noel Pouchet
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 *
 */
#ifndef SCOPTOOLS_EXEC_H
# define SCOPTOOLS_EXEC_H

# include <stdio.h>

# if HAVE_CONFIG_H
#  include <scoptools/config.h>
# endif

#include <scoptools/common.h>

# define TO_STRING__(x) #x
# define TO_STRING_(x) TO_STRING__(x)
# define STR_SCOPTOOLS_ROOT_DIR TO_STRING_(SCOPTOOLS_ROOT_DIR)

# define SCOPTOOLS_EXECV_HIDE_OUTPUT 0
# define SCOPTOOLS_EXECV_SHOW_OUTPUT 1
# define SCOPTOOLS_EXECV_NOEXIT	2


BEGIN_C_DECLS

extern void
scoptools_exec (char** args, int show_output);

extern char*
scoptools_exec_string (char** args, int show_output);

extern char*
scoptools_exec_string_noexit (char** args, int show_output);

END_C_DECLS


#endif // SCOPTOOLS_EXEC_H
