#!/bin/sh
# check_compsol.sh: this file is part of the FM project.
#
# FM, a fast and optimized C implementation of Fourier-Motzkin
# projection algorithm.
#
# Copyright (C) 2006-2008 Louis-Noel Pouchet
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# The complete GNU Lesser General Public Licence Notice can be found
#  as the `COPYING.LESSER' file in the root directory.
#
# Author:
# Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
#

FM_SOLVER_TESTS="
banerjee-1.test
banerjee-2.test
banerjee-3.test
deptest-1.test
"

SOLVER_TESTS="$FM_SOLVER_TESTS"

echo "==> Compsol tests comparison"

for i in $SOLVER_TESTS; do
    echo "* Processing test $i";
    ./fm_compsol_test "$i" "$i.out";
    ret=$?;
    z=`diff $i.sol $i.out`;
    if ! [ -z "$z" ] || [ "$ret" -ne 0 ]; then
	echo " Error in test $i";
	exit 1;
    fi
done

echo "== All done for Compsol tests comparison"


exit 0
