/*
 * fm_io_test.c: this file is part of the FM project.
 *
 * FM, a fast and optimized C implementation of Fourier-Motzkin
 * projection algorithm.
 *
 * Copyright (C) 2006-2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 *  as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#if HAVE_CONFIG_H
# include <fm/config.h>
#endif

#include <stdio.h>
#include <fm/common.h>
#include <fm/system.h>


int
main (int argc, char** argv)
{
  fprintf(stderr, "==> Testing I/O\n");

  s_fm_system_t* system;

  FILE* f = fopen("io.in.test", "r");
  fprintf(stderr, "* reading tests\n");
  system = fm_system_read (f);
  fclose(f);

  fprintf(stderr, "* writing tests\n");
  f = fopen("io.out.test.1", "w");
  fm_system_print (f, system);
  fclose(f);
  
  fprintf(stderr, "== All done for I/O.\n");

  return 0;
}
