#ifndef CLOOG_ISL_MATRIX_H
#define CLOOG_ISL_MATRIX_H

#include <cloog/isl/backend.h>
#include <cloog/int.h>

#if defined(__cplusplus)
extern "C"
  {
#endif

typedef struct isl_basic_set CloogConstraintSet;


/* The Matrix structure comes directly from PolyLib (defined in polylib/types.h)
 * here is how it looks like (at least in PolyLib 5.20.0 version).
 *
 * typedef struct matrix {
 *  unsigned NbRows;    // The number of rows (= NbConstraints in Polyhedron).
 *  unsigned NbColumns; // The number of columns (= Dimension+2 in Polyhedron).
 *  Value **p;          // An array of pointers to the beginning of each row.
 *  Value *p_Init;      // The matrix is stored here, contiguously in memory.
 *  int p_Init_size;    // Needed to free the memory allocated by mpz_init.
 *  Matrix;
 */
typedef struct matrix {
  unsigned NbRows, NbColumns;
  cloog_int_t **p;
  cloog_int_t *p_Init;
  int p_Init_size;	/* needed to free the memory allocated by mpz_init */
} Matrix;
typedef Matrix CloogMatrix;
/******************************************************************************
 *                              PolyLib interface                             *
 ******************************************************************************/
void          cloog_matrix_free(CloogMatrix *) ;
CloogMatrix * cloog_matrix_alloc(unsigned, unsigned) ;
void cloog_matrix_print(FILE *, CloogMatrix *);


struct cloogequalities {
	int			  n;
	unsigned		  total_dim;
	CloogConstraintSet	**constraints;
	int			 *types;
};
typedef struct cloogequalities CloogEqualities;

typedef struct isl_constraint *CloogConstraint;

#if defined(__cplusplus)
  }
#endif
#endif /* define _H */
