
   /**-------------------------------------------------------------------**
    **                               CLooG                               **
    **-------------------------------------------------------------------**
    **                             matrix.c                              **
    **-------------------------------------------------------------------**
    **                    First version: april 17th 2005                 **
    **-------------------------------------------------------------------**/


/******************************************************************************
 *               CLooG : the Chunky Loop Generator (experimental)             *
 ******************************************************************************
 *                                                                            *
 * Copyright (C) 2005 Cedric Bastoul                                          *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it under the  *
 * terms of the GNU General Public License as published by the Free Software  *
 * Foundation; either version 2 of the License, or (at your option) any later *
 * version.                                                                   *
 *                                                                            *
 * This software is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with software; if not, write to the Free Software Foundation, Inc.,        *
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA                     *
 *                                                                            *
 * CLooG, the Chunky Loop Generator                                           *
 * Written by Cedric Bastoul, Cedric.Bastoul@inria.fr                         *
 *                                                                            *
 ******************************************************************************/
/* CAUTION: the english used for comments is probably the worst you ever read,
 *          please feel free to correct and improve it !
 */


# include <stdlib.h>
# include <stdio.h>
# include <ctype.h>

# include <cloog/isl/matrix.h>
#define ALLOC(type) (type*)malloc(sizeof(type))
#define ALLOCN(type,n) (type*)malloc((n)*sizeof(type))


/******************************************************************************
 *                              PolyLib interface                             *
 ******************************************************************************/
/**
 * cloog_matrix_free function:
 * This function frees the allocated memory for a CloogMatrix structure
 * (matrix).
 */
void cloog_matrix_free(CloogMatrix* Mat)
{
  int i, j;
  if (Mat->p_Init)
    for (i = 0; i < Mat->NbRows; ++i)
      for (j = 0; j < Mat->NbColumns; ++j)
	cloog_int_clear(Mat->p[i][j]);
  if (Mat->p)
    free(Mat->p);
  free(Mat);
}

#define POLY_MAX_CACHE_SIZE 20
static struct {
  cloog_int_t *p;
  int 	size;
} poly_cache[POLY_MAX_CACHE_SIZE];
static int poly_cache_size = 0;

/*
 * Assign 'n' to each component of Vector 'p'
 */
static
void poly_vector_set(cloog_int_t *p,int n,unsigned length) {

  cloog_int_t *cp;
  int i;

  cp = p;
  for (i=0;i<length;i++) {
    cloog_int_set_si(*cp,n);
    cp++;
  }
  return;
}

static
cloog_int_t* poly_value_alloc(int want, int *got)
{
    int i;
    cloog_int_t *p;

    if (poly_cache_size) {
      int best;
      for (i = 0; i < poly_cache_size; ++i) {
	if (poly_cache[i].size >= want) {
	  cloog_int_t *p = poly_cache[i].p;
	  *got = poly_cache[i].size;
	  if (--poly_cache_size != i)
	    poly_cache[i] = poly_cache[poly_cache_size];
	  poly_vector_set(p, 0, want);
	  return p;
	}
	if (i == 0)
	  best = 0;
	else if (poly_cache[i].size > poly_cache[best].size)
	  best = i;
      }

      p = (cloog_int_t *)realloc(poly_cache[best].p,
				 want * sizeof(cloog_int_t));
      *got = poly_cache[best].size;
      if (--poly_cache_size != best)
	poly_cache[best] = poly_cache[poly_cache_size];
      poly_vector_set(p, 0, *got);
    } else {
      p = (cloog_int_t *)malloc(want * sizeof(cloog_int_t));
      *got = 0;
    }

    if (!p)
      return p;

    for (i = *got; i < want; ++i)
      cloog_int_init(p[i]);
    *got = want;

    return p;
}

/**
 * cloog_matrix_alloc function:
 * This function allocates the memory space for a CloogMatrix structure having
 * nb_rows rows and nb_columns columns, it set its elements to 0.
 */
CloogMatrix * cloog_matrix_alloc(unsigned nb_rows, unsigned nb_columns)
{

  Matrix *Mat;
  cloog_int_t *p, **q;
  int i;

  Mat=(Matrix *)malloc(sizeof(Matrix));
  if(!Mat) {
    return 0;
  }
  Mat->NbRows=nb_rows;
  Mat->NbColumns=nb_columns;
  if (nb_rows==0 || nb_columns==0) {
      Mat->p = (cloog_int_t **)0;
      Mat->p_Init= (cloog_int_t *)0;
      Mat->p_Init_size = 0;
  } else {
      q = (cloog_int_t **)malloc(nb_rows * sizeof(*q));
      if(!q) {
	free(Mat);
	return 0;
      }
      p = poly_value_alloc(nb_rows * nb_columns, &Mat->p_Init_size);
      if(!p) {
	free(q);
	free(Mat);
	return 0;
      }
      Mat->p = q;
      Mat->p_Init = p;
      for (i=0;i<nb_rows;i++) {
	*q++ = p;
	p += nb_columns;
      }
  }
  p = NULL;
  q = NULL;

  return Mat;
}

/**
 * cloog_matrix_print function:
 * This function prints the content of a CloogMatrix structure (matrix) into a
 * file (foo, possibly stdout).
 */
void cloog_matrix_print(FILE* foo, CloogMatrix* m)
{
  int i, j;
  if (m == NULL)
    fprintf (foo, "(null)\n");
  for (i = 0; i < m->NbRows; ++i)
    {
      for (j = 0; j < m->NbColumns; ++j)
	{
	  cloog_int_print(foo, m->p[i][j]);
	  fprintf(foo, " ");
	}
      fprintf(foo, "\n");
    }
}
