/*
 * error.h: this file is part of the PolyFeat project.
 * 
 * PolyFeat, a Polyhedral Feature extractor
 * 
 * Copyright (C) 2009 Louis-Noel Pouchet
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */
#ifndef POLYFEAT_ERROR_H
# define POLYFEAT_ERROR_H 

#include <polyfeat/common.h>

BEGIN_C_DECLS

extern const char *program_name;
extern void	set_program_name (const char *argv0);

extern void	polyfeat_warning (const char *message);
extern void	polyfeat_error (const char *message);
extern void	polyfeat_fatal (const char *message);

END_C_DECLS


#endif // POLYFEAT_ERROR_H
