/**
 * ConnectThread.java: this file is part of the LoopbackPortForwarding project.
 *
 * LoopbackPortForwarding, a tiny port forward utility between 127.0.0.1 and your public IP.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */

import java.awt.Color;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;


public class ConnectThread extends Thread {
	private SocketChannel remote_sockchan;
	private int port;
	private java.awt.TextField edit;
	
	public ConnectThread(SocketChannel sckc, java.awt.TextField edit)
	{
		this.remote_sockchan = sckc;
		this.port = sckc.socket().getLocalPort();	
		this.edit = edit;
	}
	
	public void run()
	{		
		try
		{
			// Connect to localhost on the same port.
			SocketChannel local_sockchan = SocketChannel.open(new InetSocketAddress("127.0.0.1", port));
			try
			{
				// We ensure that socket channels are made non-blocking.
				local_sockchan.configureBlocking(false);
				remote_sockchan.configureBlocking(false);
				// We are connected.
				edit.setText(port + "    " + "CONNECTED");
		    	edit.setBackground(Color.green);
				ByteBuffer buff = null;
				int rr = 0, rl = 0;
				while (true)
				{
					// Use a reversible buffer to copy local -> remote and vice-versa
					buff = ByteBuffer.allocate(4096);
					if (! local_sockchan.isOpen() || (rl = local_sockchan.read(buff)) == -1)
						break;
					buff.flip();
					if (! remote_sockchan.isOpen() || remote_sockchan.write(buff) == -1)
						break;
					buff = ByteBuffer.allocate(4096);
					if (! remote_sockchan.isOpen() || (rr = remote_sockchan.read(buff)) == -1)
						break;					
					buff.flip();
					if (! local_sockchan.isOpen() || local_sockchan.write(buff) == -1)
						break;
					// Wait 100ms if nothing was read or written, 
					// but the sockets are connected.
					if (rr == 0 && rl == 0)
						Thread.sleep(100);
				}
				// All done, close.
				if (local_sockchan.isOpen())
				{
					local_sockchan.socket().close();
					local_sockchan.close();
				}
				if (remote_sockchan.isOpen())
				{
					remote_sockchan.socket().close();
					remote_sockchan.close();
				}
				// Back to listen mode.
				edit.setText(port + "    " + "LISTEN");
		    	edit.setBackground(Color.white);
			}
			catch (Exception e)
			{	
				System.err.println(e.toString());
			}			
		}
		catch (Exception e)
		{
			// Not able to negotiate the communication with localhost.
			edit.setText(port + "    " + "127.0.0.1:" + port + " not ready (no one listening)");
	    	edit.setBackground(Color.orange);
		}
	}
}
