/**
 * ListenThread.java: this file is part of the LoopbackPortForwarding project.
 *
 * LoopbackPortForwarding, a tiny port forward utility between 127.0.0.1 and your public IP.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */

import java.awt.Color;
import java.net.*;
import java.nio.channels.*;
import java.nio.channels.spi.*;
import java.util.*;

public class ListenThread extends Thread {
	private int port;
	private java.awt.TextField edit;
	private boolean live = true;
	private ServerSocketChannel local_serversock;
	// Store the list of active sockets.
	private SocketChannel[] used_socks = new SocketChannel[10000]; 
	

	// This method is a workaround for Java bug #4665037. Under Linux, 
	// the InetAddress.getLocalHost() method may return a loopback address, instead of 
	// a public IP. 
	public static final InetAddress getLocalHost () throws UnknownHostException
	{
		try
		{
			// Okay, we're not buggy, getLocalHost returns a public IPv4 IP.
			if (! InetAddress.getLocalHost().isLoopbackAddress() && 
					! InetAddress.getLocalHost().toString().startsWith("/fe80"))
				return InetAddress.getLocalHost();
			// Fallback to technique #2: iterate on all network interfaces.
			NetworkInterface iface = null;
			InetAddress ipv6addr = null;
			for (Enumeration ifaces = NetworkInterface.getNetworkInterfaces();
				 ifaces.hasMoreElements(); )
			{
				iface = (NetworkInterface)ifaces.nextElement();
				InetAddress ip = null;
				for (Enumeration ips = iface.getInetAddresses(); ips.hasMoreElements(); )
				{
					ip = (InetAddress)ips.nextElement();
					// Avoid any local, loopback or IPv6 address.
					if (! ip.isLinkLocalAddress() && ! ip.isLoopbackAddress())
					{
						if (ip.toString().startsWith("/fe80"))
						{
							if (ipv6addr == null)
								ipv6addr = ip;
						}
						else
							return ip;
					}
				}
			}
			// The only public IP address we found was an IPv6 one.
			if (ipv6addr != null)
				return ipv6addr;
			// Strange, only loopback exists on that machine!
			return InetAddress.getLocalHost();
		}
		catch (Exception e)
		{ 
			// Some exception on NetworkInterface, we can't do better than getLocalHost.
			return InetAddress.getLocalHost();
		}
	}
	
	// Class constructor.
	public ListenThread(int port, java.awt.TextField edit)
	{
		this.edit = edit;
		this.port = port;		
		this.live = true;
	}
	
	// "Destructor".
	public void close_sockets_and_die()
	{
		// Close all sockets. It will cause sons' threads to die, 
		// because it closes all connections.
		try
		{
			local_serversock.socket().close();
			local_serversock.close();
			for (int i = 0; i < used_socks.length; ++i)
				if (used_socks[i] != null && used_socks[i].isOpen() && used_socks[i].isConnected())
					used_socks[i].close();
		}
		catch (Exception e)
		{ }
		// The ugliest hack ever to kill the thread by making it hungry of instruction..
		live = false;
	}

	// Thread activity.
	public void run()
	{
		while (true && live)
		{
			try
			{
				// Try to get a Server socket channel on public IP.
				InetAddress public_ip = ListenThread.getLocalHost();
				local_serversock = SelectorProvider.provider().openServerSocketChannel();
				local_serversock.socket().bind(new InetSocketAddress(public_ip, port));
				// Got one, we're listening.
				edit.setText(port + "    " + "LISTEN");
		    	edit.setBackground(Color.white);
				while (true && live)
				{
					// Wait for an incoming connection.
					SocketChannel scs = local_serversock.accept();
					// Got one, store the socket and create a thread to manage it.
					for (int i = 0; i < used_socks.length; ++i)
						if (used_socks[i] == null || ! used_socks[i].isOpen() || 
							! used_socks[i].isConnected())
						{
							used_socks[i] = scs;
							break;
						}
					ConnectThread cs = new ConnectThread(scs, edit);
					cs.start();
				}
			}
			catch (Exception e)
			{	
				edit.setText(port + "    " + "ERROR: local port already in use" );
		    	edit.setBackground(Color.red);
				try { Thread.sleep(1000); } catch (Exception ee) {}				
			}
		}		
	}
}
