#!/bin/sh
## make_project.sh for make_project in /home/loulou/code/project/template
## 
## Made by Loulou
## Contact: <loulou@lrde.epita.fr>
## 
## Started on  Mon Apr 17 23:14:07 2006 Loulou
## Last update Wed Apr 19 19:39:19 2006 
##

if [ $# -ne 4 ]; then
   echo "Usage: make_project.sh [name] [target_directory] [template] [header]";
   exit 1;
fi

## 
project_name="$1";
project_directory="$2"
project_type="$3";
header_file="$4";


## Misc. variables.
new_line='
';
capitalized_project_name="";
HEADER_BUFFER="";

## Ugly but useful...
make_capitalizer()
{
    if ! [ -f "./$project_type/../../capitalizer" ]; then
	echo "Compiling capitalizer";
	gcc $project_type/../../capitalizer.c -o \
	   $project_type/../../capitalizer;
    fi
    capitalized_project_name=`./$project_type/../../capitalizer "$1"`;
}


## Header functions.
add_header()
{
    comment="$1";
    header_filename="$2";
    filename="$3";
    HEADER_BUFFER="$comment";
    while read n; do
	HEADER_BUFFER="$HEADER_BUFFER$new_line$comment $n";
    done < "$header_filename";
    HEADER_BUFFER="$HEADER_BUFFER$new_line";
    HEADER_BUFFER=`echo "$HEADER_BUFFER" | sed -e "s/FILENAME/$filename/1"`
}


add_c_header()
{
    header_filename="$1";
    filename="$2";
    HEADER_BUFFER="/*";
    while read n; do
	HEADER_BUFFER="$HEADER_BUFFER$new_line * $n";
    done < "$header_filename";
    HEADER_BUFFER="$HEADER_BUFFER$new_line */$new_line$new_line";
    HEADER_BUFFER=`echo "$HEADER_BUFFER" | sed -e "s/FILENAME/$filename/1"`
}


add_sh_header()
{
    HEADER_BUFFER="#!/bin/sh"
    comment="$1";
    header_filename="$2";
    filename="$3";
    while read n; do
	HEADER_BUFFER="$HEADER_BUFFER$new_line$comment $n";
    done < "$header_filename";
    HEADER_BUFFER="$HEADER_BUFFER$new_line$new_line";
    HEADER_BUFFER=`echo "$HEADER_BUFFER" | sed -e "s/FILENAME/$filename/1"`
}


## Main code. Copy files from the appropriate template directory, fix
## (file)names and add header.

make_capitalizer "$project_name"

for i in `find $project_type | grep -v ".svn"`; do
    echo -e "\033[36mProcessing $i\033[0m"
    full_filename="${i#$project_type}";
    if ! [ -d "$i" ]; then
	filename=`basename $full_filename &>/dev/null`;
	path="${full_filename%$filename}";
	file=`sed -e "s/project/$project_name/g" $i`;
	file=`echo "$file" | sed -e "s/PROJECT/$capitalized_project_name/g"`;
	new_file=`echo "$full_filename" | sed -e "s/project/$project_name/g"`
	## Add header.
	#prefix=${full_filename%.*};
	suffix=${full_filename##*.};
	if [ "$suffix" = "am" ]; then
	    add_header "#" "$header_file"  `basename $full_filename`;
	else if [ "$suffix" = "sh" ]; then
	    add_sh_header "#" "$header_file"  `basename $full_filename`;
	else if [ "$suffix" = "ac" ] || [ "$suffix" = "m4" ]; then
	    add_header "dnl" "$header_file"  `basename $full_filename`;
	else if [ "$suffix" = "c" ] || [ "$suffix" = "h" ]; then
	    add_c_header "$header_file"  `basename $full_filename`;
	else if [ "$suffix" = "cc" ] || [ "$suffix" = "hh" ] ||
	    [ "$suffix" = "hxx" ] || [ "$suffix" = "thh" ]; then
	    add_header "//" "$header_file" `basename $full_filename`;
	else 
	    echo -e "\033[35mWARNING: No header was put in file $full_filename\033[0m";
	    HEADER_BUFFER=""
	fi fi fi fi fi;
	echo "$HEADER_BUFFER" > "$project_directory$new_file";
	echo "$file" >> "$project_directory$new_file";
	if [ -x "$i" ]; then
	    chmod +x "$project_directory$new_file";
	fi
    else
	new_file=`echo "$full_filename" | sed -e "s/project/$project_name/g"`
	mkdir -p "$project_directory$new_file";
    fi
done;
