#if HAVE_CONFIG_H
# include <project/config.h>
#endif

#include <project/common.h>
#include <project/error.h>

static void error (int exit_status, const char *mode, 
		   const char *message);

const char *program_name = NULL;

void
set_program_name (const char *path)
{
  if (! program_name)
    program_name = xstrdup (basename (path));
}

static void
error (int exit_status, const char *mode, const char *message)
{
  fprintf (stderr, "%s: %s: %s.\n", program_name, mode, message);

  if (exit_status >= 0)
    exit (exit_status);
}

void
project_warning (const char *message)
{
  error (-1, "warning", message);
}

void
project_error (const char *message)
{
  error (-1, "ERROR", message);
}

void
project_fatal (const char *message)
{
  error (EXIT_FAILURE, "FATAL", message);
}
