#if HAVE_CONFIG_H
# include <project/config.h>
#endif

#include <project/common.h>
#include <project/error.h>

void *
xmalloc (size_t num)
{
  void *new = malloc (num);
  if (! new)
    project_fatal ("Memory exhausted");
  return new;
}

void *
xrealloc (void *p, size_t num)
{
  void *new;

  if (! p)
    return xmalloc (num);

  new = realloc (p, num);
  if (! new)
    project_fatal ("Memory exhausted");

  return new;
}

void *
xcalloc (size_t num, size_t size)
{
  void *new = xmalloc (num * size);
  bzero (new, num * size);
  return new;
}
