#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include <piplib/piplib.h>
#include <piplib-gmp/piplib-gmp.h>


int
piplib_hybrid_has_integer_point (PipMatrix* domain,
				 PipMatrix* context,
				 int conservative)
{
  PipOptions* options;
  int ret = 0;
  options = pip_options_init ();
  options->Simplify = 1;
  options->Urs_parms = -1;
  options->Urs_unknowns = -1;
  options->Nq = 1;
  PipQuast* solution = NULL;
  int has_overflow = pip_solve_core (domain, context, -1, options, &solution);
  if (! has_overflow)
    {
      if ((solution != NULL) &&
	  ((solution->list != NULL) || (solution->condition != NULL)))
	ret = 1;
      pip_options_free (options);
      pip_quast_free (solution);
    }
  else if (conservative)
    return 1;
  else
    {
      int i, j;
      PipMPMatrix* mpdomain = pipmp_matrix_alloc (domain->NbRows,
						  domain->NbColumns);
      for (i = 0; i < domain->NbRows; ++i)
	for (j = 0; j < domain->NbColumns; ++j)
	  mpzvalue_set_si(mpdomain->p[i][j], VALUE_TO_INT(domain->p[i][j]));
      PipMPMatrix* mpcontext = NULL;
      if (context)
	{
	  mpcontext = pipmp_matrix_alloc (context->NbRows,
					  context->NbColumns);
	  for (i = 0; i < context->NbRows; ++i)
	    for (j = 0; j < context->NbColumns; ++j)
	      mpzvalue_set_si(mpcontext->p[i][j],
			      VALUE_TO_INT(context->p[i][j]));
	}
      PipMPOptions* mpoptions = pipmp_options_init();
      mpoptions->Simplify = 1;
      mpoptions->Urs_parms = -1;
      mpoptions->Urs_unknowns = -1;
      mpoptions->Nq = 1;
      PipMPQuast* mpsolution =
	pipmp_solve (mpdomain, mpcontext, -1, mpoptions);
      if ((mpsolution != NULL) &&
	  ((mpsolution->list != NULL) || (mpsolution->condition != NULL)))
	ret = 1;
      pipmp_quast_free (mpsolution);
      pipmp_options_free (mpoptions);
      pipmp_matrix_free (mpdomain);
      pipmp_matrix_free (mpcontext);
    }

  return ret;
}


int
piplib_hybrid_has_rational_point (PipMatrix* domain,
				  PipMatrix* context,
				  int conservative)
{
  PipOptions* options;
  int ret = 0;
  options = pip_options_init ();
  options->Simplify = 1;
  options->Urs_parms = -1;
  options->Urs_unknowns = -1;
  options->Nq = 0;
  PipQuast* solution = NULL;
  int has_overflow = pip_solve_core (domain, context, -1, options, &solution);
  if (! has_overflow)
    {
      if ((solution != NULL) &&
	  ((solution->list != NULL) || (solution->condition != NULL)))
	ret = 1;
      pip_options_free (options);
      pip_quast_free (solution);
    }
  else if (conservative)
    return 1;
  else
    {
      int i, j;
      PipMPMatrix* mpdomain = pipmp_matrix_alloc (domain->NbRows,
						  domain->NbColumns);
      for (i = 0; i < domain->NbRows; ++i)
	for (j = 0; j < domain->NbColumns; ++j)
	  mpzvalue_set_si(mpdomain->p[i][j], VALUE_TO_INT(domain->p[i][j]));
      PipMPMatrix* mpcontext = NULL;
      if (context)
	{
	  mpcontext = pipmp_matrix_alloc (context->NbRows,
					  context->NbColumns);
	  for (i = 0; i < context->NbRows; ++i)
	    for (j = 0; j < context->NbColumns; ++j)
	      mpzvalue_set_si(mpcontext->p[i][j],
			      VALUE_TO_INT(context->p[i][j]));
	}
      PipMPOptions* mpoptions = pipmp_options_init();
      mpoptions->Simplify = 1;
      mpoptions->Urs_parms = -1;
      mpoptions->Urs_unknowns = -1;
      mpoptions->Nq = 0;
      PipMPQuast* mpsolution =
	pipmp_solve (mpdomain, mpcontext, -1, mpoptions);
      if ((mpsolution != NULL) &&
	  ((mpsolution->list != NULL) || (mpsolution->condition != NULL)))
	ret = 1;
      pipmp_quast_free (mpsolution);
      pipmp_options_free (mpoptions);
      pipmp_matrix_free (mpdomain);
      pipmp_matrix_free (mpcontext);
    }

  return ret;
}


int
piplib_hybrid_has_rational_point_mp (PipMatrix* domain,
				     PipMatrix* context)
{
  int ret = 0;
  
  int i, j;
  PipMPMatrix* mpdomain = pipmp_matrix_alloc (domain->NbRows,
					      domain->NbColumns);
  for (i = 0; i < domain->NbRows; ++i)
    for (j = 0; j < domain->NbColumns; ++j)
      mpzvalue_set_si(mpdomain->p[i][j], VALUE_TO_INT(domain->p[i][j]));
  PipMPMatrix* mpcontext = NULL;
  if (context)
    {
      mpcontext = pipmp_matrix_alloc (context->NbRows,
				      context->NbColumns);
      for (i = 0; i < context->NbRows; ++i)
	for (j = 0; j < context->NbColumns; ++j)
	  mpzvalue_set_si(mpcontext->p[i][j],
			  VALUE_TO_INT(context->p[i][j]));
    }
  PipMPOptions* mpoptions = pipmp_options_init();
  mpoptions->Simplify = 1;
  mpoptions->Urs_parms = -1;
  mpoptions->Urs_unknowns = -1;
  mpoptions->Nq = 0;
  PipMPQuast* mpsolution =
    pipmp_solve (mpdomain, mpcontext, -1, mpoptions);
  if ((mpsolution != NULL) &&
      ((mpsolution->list != NULL) || (mpsolution->condition != NULL)))
    ret = 1;
  pipmp_quast_free (mpsolution);
  pipmp_options_free (mpoptions);
  pipmp_matrix_free (mpdomain);
  pipmp_matrix_free (mpcontext);

  return ret;
}


int
piplib_hybrid_has_integer_point_mp (PipMatrix* domain,
				    PipMatrix* context)
{
  int ret = 0;
  
  int i, j;
  PipMPMatrix* mpdomain = pipmp_matrix_alloc (domain->NbRows,
					      domain->NbColumns);
  for (i = 0; i < domain->NbRows; ++i)
    for (j = 0; j < domain->NbColumns; ++j)
      mpzvalue_set_si(mpdomain->p[i][j], VALUE_TO_INT(domain->p[i][j]));
  PipMPMatrix* mpcontext = NULL;
  if (context)
    {
      mpcontext = pipmp_matrix_alloc (context->NbRows,
				      context->NbColumns);
      for (i = 0; i < context->NbRows; ++i)
	for (j = 0; j < context->NbColumns; ++j)
	  mpzvalue_set_si(mpcontext->p[i][j],
			  VALUE_TO_INT(context->p[i][j]));
    }
  PipMPOptions* mpoptions = pipmp_options_init();
  mpoptions->Simplify = 1;
  mpoptions->Urs_parms = -1;
  mpoptions->Urs_unknowns = -1;
  mpoptions->Nq = 1;
  PipMPQuast* mpsolution =
    pipmp_solve (mpdomain, mpcontext, -1, mpoptions);
  if ((mpsolution != NULL) &&
      ((mpsolution->list != NULL) || (mpsolution->condition != NULL)))
    ret = 1;
  pipmp_quast_free (mpsolution);
  pipmp_options_free (mpoptions);
  pipmp_matrix_free (mpdomain);
  pipmp_matrix_free (mpcontext);

  return ret;
}
