/*
 * Polynomial.cpp: This file is part of the Parametric Tiling project.
 * 
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 * 
 * Copyright (C) 2011 Sanket Tavargeri
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 * 
 */

#if HAVE_CONFIG_H
# include <ptile/config.h>
#endif

# include <ptile/Polynomial.hpp>
# include <string>

using namespace std;


  Polynomial::Polynomial(int size)
  {
    coefficient = 1;
    this->size = size;
    AllocateMemory();
    for (int i = 0; i < size; i++)
      {
	exponents[i] = 0;
      }// for int i = 0
  }

  Polynomial::Polynomial()
  {
    Polynomial(1);
  }

  Polynomial::Polynomial(int size, string *exponent_names)
  {
    Polynomial(1);
    CopyExponentNames(exponent_names);
  }//Polynomial(int size, string *exponent_names)

  void Polynomial::AllocateMemory()
  {
    exponents = new int[size];
    names = new string[size];
  }// AllocateMemory()


  void Polynomial::CopyExponentNames(string *param_names)
  {
    // names = new string[size];
    for (int i = 0; i < size; i++)
      {
	names[i] = param_names[i];
      }//for (int i = 0; i < size; i++)
  }//void CopyExponentNames(string *names)

  void Polynomial::CloneFrom(Polynomial poly)
  {
    coefficient = poly.coefficient;
    // if (coefficient != 0)
    {
      size = poly.size;
      AllocateMemory();
      for (int i = 0; i < size; i++)
	{
	  exponents[i] = poly.exponents[i];
	}// for int i = 0

      CopyExponentNames(poly.names);
    }// if coefficient != 0
  }// CloneFrom()

  Polynomial Polynomial::GetIdentityPolynomial(string *exponent_names)
  {
    Polynomial poly;
    poly.coefficient = 1;
    poly.size = size;
    poly.AllocateMemory();
    for (int i = 0; i < size; i++)
      {
	poly.exponents[i] = 0;
	poly.names[i] = exponent_names[i];
      }// for int i

    return poly;
  }//GetIdentityPolynomial()

  void Polynomial::SetCoefficientAt(int position, int coefficient)
  {
    for (int i = 0; i < size; i++)
      {
	if (i == position)
	  {
	    exponents[i] = coefficient;
	    return;
	  }// if (i == position)
      }// for (int i = 0; i < size; i++)
  }//void SetCoefficientAt(iteratorNumber, 1)

  void Polynomial::Print()
  {
    //printf("Polynomial\n");
    //printf("coefficient - %f, size - %d, exponents - ", coefficient, size);

    if (coefficient != 0)
      {
	for (int i = 0; i < size; i++)
	  {
	    //printf("%d ", exponents[i]);

	    // Printing the exponent name
	    //printf("%s ", names[i].c_str());
	  }// for i
      }// if (coefficient != 0)

    //printf("\n");
  }// Print()
