/*
 * ScoplibToExpressionConverter.cpp: This file is part of the
 * Parametric Tiling project.
 * 
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 * 
 * Copyright (C) 2011 Sanket Tavargeri
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include<string>
#include<iostream>
#include<vector>
#include <set>
#include<sstream>

# include <ptile/ScoplibToExpressionConverter.hpp>

  vector<Expression*>* ScoplibToExpressionConverter::ReadAndParseScoplibToExpressions(scoplib_scop_p scoplibScop)
  {
    vector<Expression*>* expressionVector = NULL;

    string language;
    string SCoP;
    int ContextRows, ContextColumns;
    int *Context;
    int ParamNamesSet;
    string *ParamNames;
    int NumberOfStatements;
    int NumberOfDomains;
    int DomainRows, DomainColumns;
    vector<Expression*> *exprs = NULL;

    // Pointer of pointers. Each pointer pointing to one statement information
    int *StatementDomains;

    int Options[3];
    int IteratorNamesSet;
    string *IteratorNames;
    int NumberOfScatteringFunctions;

    int NumberOfParameters = 0;
    int NumberOfIterators = 0;

    /*Parsing starts*/
    ParamNamesSet = 1;
    NumberOfParameters = scoplibScop->nb_parameters;
    ParamNames = new string[NumberOfParameters];

    //cout<<"Parameters:"<<endl;
    for (int i = 0; i < NumberOfParameters; i++)
      {
	ParamNames[i] = string(scoplibScop->parameters[i]);
	//cout<<"Parameter name: "<<ParamNames[i]<<endl;

	/*
	  stringstream oss;
	  oss<<i;
	  ParamNames[i] = "N" + oss.str();
	*/
      }// for (int i = 0; i < NumberOfParameters; i++)


    if (scoplibScop->statement != NULL)
      {
	// We will parse only the first statement. This is assuming that only one statement is
	// given to tile at a time or the convex hull

	NumberOfStatements = 1;
	scoplib_statement_p statement = scoplibScop->statement;
	NumberOfIterators = statement->nb_iterators;
	IteratorNamesSet = 1;
	IteratorNames = new string[NumberOfIterators];

	//cout<<"Really getting here"<<endl;
	//cout<<"IteratorNames"<<endl;
	for (int i = 0; i < NumberOfIterators; i++)
	  {
	    IteratorNames[i] = string(statement->iterators[i]);
	    //cout<<"IteratorName: "<<statement->iterators[i]<<endl;

	    /*
	      stringstream oss;
	      oss<<i;
	      IteratorNames[i] = "i" + oss.str();
	    */
	  }// for (int i = 0; i < NumberOfIterators; i++)

	scoplib_matrix_list_p domainList = statement->domain;
    
	if (domainList != NULL)
	  {
	    NumberOfDomains = 1;
	    scoplib_matrix_p domain = domainList->elt;
	    // Again assuming that there is only one domain

	    //printf("Retrieving NbRows & NbColumns\n");
	    DomainRows = domain->NbRows;
	    DomainColumns = domain->NbColumns;
	    StatementDomains = new int[DomainRows * DomainColumns];
	    //printf("DomainRows = %d, DomainColumns = %d\n", DomainRows, DomainColumns);

	    for (int i = 0; i < DomainRows; i++)
	      {
		//             // Assumption: scoplib_int_t = int
		//printf("Accessing row = %d ", i);
		for (int j = 0; j < DomainColumns; j++)
		  {
		    StatementDomains[i * DomainColumns + j] =  (domain->p_Init)[i * DomainColumns + j]; // row[j];
		    //printf("%d ", StatementDomains[i * DomainColumns + j]);
		  }// for (int j = 0; j < DomainColumns; j++)

		//printf("\n");
	      }// for (int i = 0; i < DomainRows; i++)
	  }// if (domainList != NULL)

	//printf("Oh! that was not a problem then\n");

	// count the number of statements
	int localCount = 1;
	struct scoplib_statement* temp = scoplibScop->statement;
	while (temp->next != NULL)
	  {
	    temp = temp->next;
	    localCount++;
	  }// while (temp->next != NULL)

	//printf("Number of statements = %d\n", localCount);

      }// if (scoplibScop->statement != NULL)

    /*******************************************************************/
    // Here the assumption is that there is only one statement
    // for (int i = 0; i < NumberOfStatements; i++)
    {
      // Form expressions
      //printf("Calling FormExpressions()\n");			
      expressionVector = GeneralUtilityClass::FormExpressions(StatementDomains,
							      NumberOfDomains*DomainRows*DomainColumns, DomainRows, DomainColumns, 
							      NumberOfIterators, NumberOfParameters, 
							      ParamNamesSet, ParamNames, IteratorNamesSet, IteratorNames);

      //printf("Returning from FormExpressions()\n");
    }// for (i = 0; i < NumberOfStatements; i++)

    //cout<<"Printing expressions"<<endl;
    ExpressionLibrary::PrintExpressions(expressionVector);
  

    //printf("Safely out of here too!\n");
    return expressionVector;
  }// vector<Expression*>* ReadAndParseScoplibToExpressions(scoplib_scop_p scoplibScop)

