/*
 * options.cpp: This file is part of the PTile project.
 *
 * PTile: A PAST-to-PAST parametric tiling software
 *
 * Copyright (C) 2011 Sanket Tavargeri
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 *
 */

#if HAVE_CONFIG_H
# include <ptile/config.h>
#endif


#include <ptile/options.h>



s_ptile_options_t*
ptile_options_malloc ()
{
  s_ptile_options_t* ret = XMALLOC(s_ptile_options_t, 1);

  ret->symboltable = NULL;
  ret->fullTileSeparation = 0;
  ret->level = 1;
  ret->parallel = 0;
  ret->RSFME = 1;
  ret->verbose_level = 1;
  ret->data_is_char = 0;
  ret->quiet = 0;

  return ret;
}

void
ptile_options_free (s_ptile_options_t* ptopts)
{
  //symbol_table_free (ptopts->symboltable);
  XFREE(ptopts);
}
