/*
 * dependence.c: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */

#include <letsee/dependence.h>

/**
 * This file collects convenience functions for the 'usr' structure
 * used to tag Candl dependences in LetSee.
 */

/**
 *
 *
 */
s_dependence_tags_t*
ls_dependence_tags_alloc ()
{
  s_dependence_tags_t* ret = XMALLOC(s_dependence_tags_t, 1);

  ret->id = 0;
  ret->solved = 0;
  ret->tag = 0;

  return ret;
}


/**
 *
 *
 */
void
ls_dependence_tags_free (s_dependence_tags_t* t)
{
  if (t)
    XFREE(t);
}


/**
 *
 *
 */
void
ls_dependence_init (s_candl_dependence_t* dep)
{
  for (; dep; dep = dep->next)
    dep->usr = ls_dependence_tags_alloc ();
}


/**
 *
 *
 */
void
ls_dependence_clear (s_candl_dependence_t* dep)
{
  for (; dep; dep = dep->next)
    ls_dependence_tags_free (dep->usr);
}
