/*
 * fdspace.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_FDSPACE_H
# define LETSEE_FDSPACE_H

# include <letsee/common.h>
# include <letsee/options.h>
# include <letsee/space.h>
# include <letsee/transformations.h>
# include <letsee/farkas.h>
# include <letsee/graph.h>
# include <letsee/schedspace.h>
# include <fm/piptools.h>
# include <fm/solution.h>
# include <fm/system.h>
# include <fm/solver.h>
# include <fm/compsol.h>
# include <fm/vector.h>
# include <fm/rational.h>
# include <candl/candl.h>

# define LS_FDSPACE_NO	0
# define LS_FDSPACE_GT	1
# define LS_FDSPACE_GE	2
# define LS_FDSPACE_EQ	3



BEGIN_C_DECLS

extern
s_ls_space_t*
ls_fdspace_build (CandlProgram* program,
		  CandlDependence* dependences,
		  s_ls_options_t* options);

extern
s_fm_compsol_t*
ls_fdspace_compute_one (s_graph_t* graph,
			CandlProgram* program,
			s_ls_options_t* options,
			int cur_depth);

extern
void
ls_fdspace_add_normalization_constraints (CandlProgram* program, 
					  s_ls_options_t* options, 
					  s_fm_solution_t* sol);


END_C_DECLS


#endif // LETSEE_FDSPACE_H
