/*
 * heuristic-plutom.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_HEURISTIC_PLUTOM_H
# define LETSEE_HEURISTIC_PLUTOM_H

# include <letsee/space.h>
# include <candl/program.h>
# include <letsee/options.h>
# include <fm/vector.h>
# include <fm/solution.h>
# include <letsee/heuristics.h>
# include <letsee/graph.h>
# include <letsee/farkas.h>
# include <letsee/fdspace.h>


BEGIN_C_DECLS


extern
void
ls_heuristic_plutom (s_ls_space_t* space,
		     CandlProgram* program,
		     s_ls_options_t* options,
		     int mode);


END_C_DECLS


#endif // LETSEE_HEURISTIC_PLUTOM_H
