/*
 * oset.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_OSET_H
# define LETSEE_OSET_H

# include <letsee/common.h>
# include <fm/system.h>
# include <fm/piptools.h>

# define LS_OSET_UNSET  -1
# define LS_OSET_ELIM	-2

BEGIN_C_DECLS

extern
int
ls_oset_idx_p (int n, int i, int j);

extern
int
ls_oset_idx_t (int n, int i, int j);

extern
s_fm_system_t*
ls_oset_build_system (int size, int* screen);

extern
s_fm_vector_t*
ls_oset_convert_ordering (s_fm_vector_t* draw, int size);

extern
s_fm_vector_t*
ls_oset_convert_ordering_pip (s_fm_vector_t* draw, int size);

END_C_DECLS


#endif // LETSEE_OSET_H
