/*
 * pocc-driver.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006,2007,2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_POCC_DRIVER_H
# define LETSEE_POCC_DRIVER_H

# include <stdio.h>
# include <letsee/common.h>
# include <letsee/options.h>
# include <letsee/space.h>
# ifdef HAVE_LIBPOCC_UTILS
#  include <pocc-utils/options.h>
# endif
# include <candl/program.h>
# include <candl/options.h>
# include <candl/dependence.h>
# include <fm/compsol.h>


BEGIN_C_DECLS

#ifdef HAVE_LIBPOCC_UTILS
extern
int
letsee_pocc (CandlProgram* program,
	     s_ls_options_t* options,
	     s_pocc_utils_options_t* puoptions);
#endif /* ! HAVE_LIBPOCC_UTILS */

END_C_DECLS


#endif // LETSEE_POCC_DRIVER_H
