/*
 * oset.c: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */
#if HAVE_CONFIG_H
# include <letsee/config.h>
#endif

#include <letsee/oset.h>


#define TYPE_P 1
#define TYPE_T 2

inline int
ls_oset_idx_t (int n, int i, int j);


inline
int
ls_oset_idx_p (int n, int i, int j)
{
  int val = (i - 1) * n - ((i * (i - 1)) / 2) + (j - i);
  /// FIXME: reverted e and p
  //int val = (n * (n - 1)) / 2 + ls_oset_idx_t (n, i, j);
  return val;
}


inline
int
ls_oset_idx_t (int n, int i, int j)
{
  int val = (n * (n - 1)) / 2 + ls_oset_idx_p (n, i, j);
  /// FIXME: reverted e and p
  //int val = (i - 1) * n - ((i * (i - 1)) / 2) + (j - i);

  return val;
}


inline
void
val_of (int n, int val, int* i, int* j, int* type)
{
  if (val > (n * (n - 1)) / 2)
    {
      *type = TYPE_T;
      val -= (n * (n - 1)) / 2;
    }
  else
    *type = TYPE_P;

  int k, l;
  for (k = 1; k <= n; ++k)
    for (l = k + 1; l <= n; ++l)
      if (ls_oset_idx_p (n, k, l) == val)
	{
	  *i = k;
	  *j = l;
	}
}


int nb_rejected_cst = 0;

int
ls_oset_needed_cst (s_fm_vector_t* v, int* screen)
{
  return 1;
  

  int i;
  int pos = 0;
  int neg = 0;
  int unknown = 0;

  nb_rejected_cst++;
  for (i = 1; i < v->size - 1; ++i)
    {
      if (v->vector[i].num != 0)
	{
	  if (v->vector[i].num < 0)
	    neg += -v->vector[i].num;
	  if (v->vector[i].num > 0)
	    pos += v->vector[i].num;
	  if (screen[i - 1] > LS_OSET_UNSET)
	    {
	      v->vector[v->size - 1].num += v->vector[i].num * screen[i - 1];
	      v->vector[i].num = 0;
	    }
	  else
	    ++unknown;
	}
    }
  if (unknown == 1)
    {
      for (i = 1; i < v->size - 1 && v->vector[i].num == 0; ++i)
	;
      screen[i - 1] = v->vector[v->size - 1].num / v->vector[i].num;
      if (screen[i - 1] < 0)
	screen[i - 1] *= -1;
      return 0;
    }
  if (pos <= - v->vector[v->size - 1].num ||
      neg <= v->vector[v->size - 1].num)
    return 0;
  nb_rejected_cst--;
  return 1;
}



s_fm_system_t*
ls_oset_build_system (int size, int* screen)
{
  // Compute the size of the system.
  int nb_vars = size * (size - 1);
  int nb_cols = nb_vars + 2;

  s_fm_system_t* s = fm_system_alloc (0, nb_cols);
  s_fm_vector_t* v;
  int i, j, k;
  int n = size;
  nb_rejected_cst = 0;
/*   printf ("screen: "); */
/*   for (i = 0; i < nb_vars; ++i) */
/*     printf ("%d ", screen[i]); */
/*   printf ("\n"); */
/*   printf ("START\n"); */
/*   printf ("STEP 1\n"); */
  // Set relaxed mutual exclusion.
  for (i = 1; i <= n; ++i)
    for (j = i + 1; j <= n; ++j)
      {
	if (screen[ls_oset_idx_p (n, i, j) - 1] > LS_OSET_UNSET &&
	    screen[ls_oset_idx_t (n, i, j) - 1] > LS_OSET_UNSET)
	  continue;
	if (screen[ls_oset_idx_p (n, i, j) - 1] == 1 &&
	    screen[ls_oset_idx_t (n, i, j) - 1] <= LS_OSET_UNSET)
	  screen[ls_oset_idx_t (n, i, j) - 1] = 0;
	else if (screen[ls_oset_idx_p (n, i, j) - 1] == LS_OSET_UNSET &&
		 screen[ls_oset_idx_t (n, i, j) - 1] == 1)
	  screen[ls_oset_idx_p (n, i, j) - 1] = 0;
	else if (screen[ls_oset_idx_p (n, i, j) - 1] == LS_OSET_UNSET &&
		 screen[ls_oset_idx_t (n, i, j) - 1] <= LS_OSET_UNSET)
	  {
	    v = fm_vector_alloc (nb_cols);
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, j));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j));
	    fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	    if (screen[ls_oset_idx_t (n, i, j) - 1] == LS_OSET_UNSET)
	      fm_vector_set_ineq (v);
	    fm_system_add_line (s, v);
	  }
      }
/*   printf ("STEP 2\n"); */
  v = fm_vector_alloc (nb_cols);
  int need_alloc = 0;
  for (i = 1; i <= n; ++i)
    {
/* 	printf ("STEP 2.1: %d / %d (size: %d lines)\n", i, n, s->nb_lines); */
/* 	printf ("Rejected constraints: %d\n", nb_rejected_cst); */
      for (j = i + 1; j <= n; ++j)
	{
	  // Remove inconsistent t values (new).
	  for (k = j + 1; k <= n; ++k)
	    {
	      if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 ||
		  screen[ls_oset_idx_t (n, i, k) - 1] == 0 ||
		  screen[ls_oset_idx_t (n, j, k) - 1] == 1)
		continue;
	      if (need_alloc)
		{
		  v = fm_vector_alloc (nb_cols);
		  need_alloc = 0;
		}
	      else
		  fm_vector_init (v, nb_cols);
	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j));
	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, k));
	      fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, j, k));
	      fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	      fm_vector_set_ineq (v);
	      if (ls_oset_needed_cst (v, screen))
		{
		  fm_system_add_line (s, v);
		  need_alloc = 1;
		}
	    }
	  for (k = j + 1; k <= n; ++k)
	    {
	      if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 ||
		  screen[ls_oset_idx_t (n, j, k) - 1] == 0 ||
		  screen[ls_oset_idx_t (n, i, k) - 1] == 1)
		continue;
	      if (need_alloc)
		{
		  v = fm_vector_alloc (nb_cols);
		  need_alloc = 0;
		}
	      else
		fm_vector_init (v, nb_cols);
	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j));
	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, j, k));
	      fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, i, k));
	      fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	      fm_vector_set_ineq (v);
	      if (ls_oset_needed_cst (v, screen))
		{
		  fm_system_add_line (s, v);
		  need_alloc = 1;
		}
/* 	      else */
/* 		fm_vector_free (v); */
	    }
	// added case 5
	for (k = j + 1; k <= n; ++k)
	  {
	    if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 ||
		screen[ls_oset_idx_p (n, i, k) - 1] == 0 ||
		screen[ls_oset_idx_p (n, j, k) - 1] == 1)
	      continue;
	    if (need_alloc)
	      {
		v = fm_vector_alloc (nb_cols);
		need_alloc = 0;
	      }
	    else
	      fm_vector_init (v, nb_cols);
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k));
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, j, k));
	    fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	    fm_vector_set_ineq (v);
	    if (ls_oset_needed_cst (v, screen))
	      {
		fm_system_add_line (s, v);
		need_alloc = 1;
	      }
/* 	    else */
/* 	      fm_vector_free (v); */
	  }
	// added case 3
	for (k = j + 1; k <= n; ++k)
	  {
	    if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 ||
		screen[ls_oset_idx_p (n, j, k) - 1] == 0 ||
		screen[ls_oset_idx_p (n, i, k) - 1] == 1)
	      continue;
	    if (need_alloc)
	      {
		v = fm_vector_alloc (nb_cols);
		need_alloc = 0;
	      }
	    else
	      fm_vector_init (v, nb_cols);
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, j, k));
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, k));
	    fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	    fm_vector_set_ineq (v);
	    if (ls_oset_needed_cst (v, screen))
	      {
		fm_system_add_line (s, v);
		need_alloc = 1;
	      }
/* 	    else */
/* 	      fm_vector_free (v); */
	  }
	// Remove inconsistent p values (bis).
	for (k = i + 1; k < j; ++k)
	  {
	    if (screen[ls_oset_idx_p (n, i, k) - 1] == 0 ||
		screen[ls_oset_idx_p (n, k, j) - 1] == 0 ||
		screen[ls_oset_idx_p (n, i, j) - 1] == 1)
	      continue;
	    if (need_alloc)
	      {
		v = fm_vector_alloc (nb_cols);
		need_alloc = 0;
	      }
	    else
	      fm_vector_init (v, nb_cols);
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, k, j));
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j));
	    fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	    fm_vector_set_ineq (v);
	    if (ls_oset_needed_cst (v, screen))
	      {
		fm_system_add_line (s, v);
		need_alloc = 1;
	      }
/* 	    else */
/* 	      fm_vector_free (v); */
	  }
	// added case 6
	for (k = i + 1; k < j; ++k)
	  {
	    if (screen[ls_oset_idx_t (n, k, j) - 1] == 0 ||
		screen[ls_oset_idx_p (n, i, k) - 1] == 0 ||
		screen[ls_oset_idx_p (n, i, j) - 1] == 1)
	      continue;
	    if (need_alloc)
	      {
		v = fm_vector_alloc (nb_cols);
		need_alloc = 0;
	      }
	    else
	      fm_vector_init (v, nb_cols);
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, k, j));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k));
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j));
	    fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	    fm_vector_set_ineq (v);
	    if (ls_oset_needed_cst (v, screen))
	      {
		fm_system_add_line (s, v);
		need_alloc = 1;
	      }
/* 	    else */
/* 	      fm_vector_free (v); */
	  }
	// case 1
	for (k = j + 1; k <= n; ++k)
	  {
	    if (need_alloc)
	      {
		v = fm_vector_alloc (nb_cols);
		need_alloc = 0;
	      }
	    else
	      fm_vector_init (v, nb_cols);
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j));
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, i, j));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k));
	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, k));
	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, j, k));
	    fm_vector_assign_int_idx (v, -0, nb_cols - 1);
	    fm_vector_set_ineq (v);
	    if (ls_oset_needed_cst (v, screen))
	      {
		fm_system_add_line (s, v);
		need_alloc = 1;
	      }
/* 	    else */
/* 	      fm_vector_free (v); */
	  }
	}
      }
/*   printf ("STEP 3\n"); */

  // Set variables to be binary, or to their value.
  for (i = 1; i < nb_cols - 1; ++i)
    {
      if (screen[i - 1] < LS_OSET_UNSET)
	continue;
      v = fm_vector_alloc (nb_cols);
      fm_vector_assign_int_idx (v, 1, i);
      if (screen[i - 1] == LS_OSET_UNSET)
	{
	  fm_vector_set_ineq (v);
	  fm_system_add_line (s, v);
	  v = fm_vector_alloc (nb_cols);
	  fm_vector_assign_int_idx (v, -1, i);
	  fm_vector_assign_int_idx (v, 1, nb_cols - 1);
	  fm_vector_set_ineq (v);
	}
      else
	fm_vector_assign_int_idx (v, - screen[i - 1], v->size - 1);
      fm_system_add_line (s, v);
    }
/*     fm_system_print (stdout, s); */
/*   printf ("STOP\n"); */

  return s;
}


/* s_fm_system_t* */
/* ls_oset_build_system_bak (int size, int* screen) */
/* { */
/*   // Compute the size of the system. */
/*   int nb_vars = size * (size - 1); */
/*   int nb_cols = nb_vars + 2; */

/*   s_fm_system_t* s = fm_system_alloc (0, nb_cols); */
/*   s_fm_vector_t* v; */
/*   int i, j, k; */
/*   int n = size; */

/*   // Set variables to be binary. */
/*   for (i = 1; i < nb_cols - 1; ++i) */
/*     { */
/*       v = fm_vector_alloc (nb_cols); */
/*       fm_vector_assign_int_idx (v, 1, i); */
/*       if (screen[i - 1] <= LS_OSET_UNSET) */
/* 	{ */
/* 	  fm_vector_set_ineq (v); */
/* 	  fm_system_add_line (s, v); */
/* 	  v = fm_vector_alloc (nb_cols); */
/* 	  fm_vector_assign_int_idx (v, -1, i); */
/* 	  fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	  fm_vector_set_ineq (v); */
/* 	} */
/*       else */
/* 	fm_vector_assign_int_idx (v, - screen[i - 1], v->size - 1); */
/*       fm_system_add_line (s, v); */
/*     } */

/*   // Set relaxed mutual exclusion. */
/*   for (i = 1; i <= n; ++i) */
/*     for (j = i + 1; j <= n; ++j) */
/*       { */
/* 	if (screen[ls_oset_idx_p (n, i, j) - 1] == 1 && */
/* 	    screen[ls_oset_idx_t (n, i, j) - 1] == LS_OSET_UNSET) */
/* 	  { */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, i, j)); */
/* 	    fm_system_add_line (s, v); */
/* 	  } */
/* 	else if (screen[ls_oset_idx_p (n, i, j) - 1] == LS_OSET_UNSET && */
/* 		 screen[ls_oset_idx_t (n, i, j) - 1] == 1) */
/* 	  { */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j)); */
/* 	    fm_system_add_line (s, v); */
/* 	  } */
/* 	else if (screen[ls_oset_idx_p (n, i, j) - 1] == LS_OSET_UNSET && */
/* 		 screen[ls_oset_idx_t (n, i, j) - 1] <= LS_OSET_UNSET) */
/* 	  { */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	    if (screen[ls_oset_idx_t (n, i, j) - 1] == LS_OSET_UNSET) */
/* 	      fm_vector_set_ineq (v); */
/* 	    fm_system_add_line (s, v); */
/* 	  } */
/*       } */

/*     for (i = 1; i <= n; ++i) */
/*       for (j = i + 1; j <= n; ++j) */
/* 	{ */
/* 	  // Remove inconsistent t values (new). */
/* 	  for (k = j + 1; k <= n; ++k) */
/* 	    { */
/* 	      if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 || */
/* 		  screen[ls_oset_idx_t (n, i, k) - 1] == 0 || */
/* 		  screen[ls_oset_idx_t (n, j, k) - 1] == 1) */
/* 		continue; */
/* 	      v = fm_vector_alloc (nb_cols); */
/* 	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j)); */
/* 	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, k)); */
/* 	      fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, j, k)); */
/* 	      fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	      fm_vector_set_ineq (v); */
/* 	      if (ls_oset_needed_cst (v, screen)) */
/* 		fm_system_add_line (s, v); */
/* 	    } */
/* 	  for (k = j + 1; k <= n; ++k) */
/* 	    { */
/* 	      if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 || */
/* 		  screen[ls_oset_idx_t (n, j, k) - 1] == 0 || */
/* 		  screen[ls_oset_idx_t (n, i, k) - 1] == 1) */
/* 		continue; */
/* 	      v = fm_vector_alloc (nb_cols); */
/* 	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j)); */
/* 	      fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, j, k)); */
/* 	      fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, i, k)); */
/* 	      fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	      fm_vector_set_ineq (v); */
/* 	      if (ls_oset_needed_cst (v, screen)) */
/* 		fm_system_add_line (s, v); */
/* 	    } */
/* 	// added case 5 */
/* 	for (k = j + 1; k <= n; ++k) */
/* 	  { */
/* 	    if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, i, k) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, j, k) - 1] == 1) */
/* 	      continue; */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k)); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, j, k)); */
/* 	    fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	    fm_vector_set_ineq (v); */
/* 	    if (ls_oset_needed_cst (v, screen)) */
/* 	      fm_system_add_line (s, v); */
/* 	  } */
/* 	// added case 3 */
/* 	for (k = j + 1; k <= n; ++k) */
/* 	  { */
/* 	    if (screen[ls_oset_idx_t (n, i, j) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, j, k) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, i, k) - 1] == 1) */
/* 	      continue; */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, j, k)); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, k)); */
/* 	    fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	    fm_vector_set_ineq (v); */
/* 	    if (ls_oset_needed_cst (v, screen)) */
/* 	      fm_system_add_line (s, v); */
/* 	  } */
/* 	// Remove inconsistent p values (bis). */
/* 	for (k = i + 1; k < j; ++k) */
/* 	  { */
/* 	    if (screen[ls_oset_idx_p (n, i, k) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, k, j) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, i, j) - 1] == 1) */
/* 	      continue; */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, k, j)); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	    fm_vector_set_ineq (v); */
/* 	    if (ls_oset_needed_cst (v, screen)) */
/* 	      fm_system_add_line (s, v); */
/* 	  } */
/* 	// added case 6 */
/* 	for (k = i + 1; k < j; ++k) */
/* 	  { */
/* 	    if (screen[ls_oset_idx_t (n, k, j) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, i, k) - 1] == 0 || */
/* 		screen[ls_oset_idx_p (n, i, j) - 1] == 1) */
/* 	      continue; */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, k, j)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k)); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, 1, nb_cols - 1); */
/* 	    fm_vector_set_ineq (v); */
/* 	    if (ls_oset_needed_cst (v, screen)) */
/* 	      fm_system_add_line (s, v); */
/* 	  } */
/* 	// case 1 */
/* 	for (k = j + 1; k <= n; ++k) */
/* 	  { */
/* 	    v = fm_vector_alloc (nb_cols); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_t (n, i, j)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_p (n, i, k)); */
/* 	    fm_vector_assign_int_idx (v, -1, ls_oset_idx_t (n, i, k)); */
/* 	    fm_vector_assign_int_idx (v, 1, ls_oset_idx_p (n, j, k)); */
/* 	    fm_vector_assign_int_idx (v, -0, nb_cols - 1); */
/* 	    fm_vector_set_ineq (v); */
/* 	    if (ls_oset_needed_cst (v, screen)) */
/* 	      fm_system_add_line (s, v); */
/* 	  } */
/*       } */

/*   return s; */
/* } */


int iter = 0;


s_fm_vector_t*
ls_oset_convert_ordering (s_fm_vector_t* draw, int size)
{
  int i, j;
  int val_p, val_t, val_s;
  int elemt[size];
  int partid = 0;
  int tmp;
  int swapped;
  s_fm_vector_t* v = fm_vector_alloc (size + 1);

  // Initialize the element array.
  for (i = 0; i < size; ++i)
    elemt[i] = i + 1;
  
  // Bubble sort on it. Elements that are in the same partition are
  // next to each other.
  do
    {
      swapped = 0;
      for (i = 0; i < size - 1; ++i)
	{
	  if (elemt[i] < elemt[i + 1])
	    {
	      val_p =
		draw->vector[ls_oset_idx_p (size, elemt[i], elemt[i + 1])].num;
	      val_t =
		draw->vector[ls_oset_idx_t (size, elemt[i], elemt[i + 1])].num;
	    }
	  else
	    {
	      // Element has already been swapped.
	      val_p = 1;
	    }
	  val_s = val_p == 0 && val_t == 0;

	  if (val_s == 1)
	    {
	      tmp = elemt[i];
	      elemt[i] = elemt[i + 1];
	      elemt[i + 1] = tmp;
	      swapped = 1;
	    }
	}
    }
  while (swapped);

  // Assign the partition id to each element.
  partid = 0;
  fm_vector_assign_int_idx (v, partid, 1);
  for (i = 1; i < size; ++i)
    {
      if (elemt[i - 1] < elemt[i])
	val_t = draw->vector[ls_oset_idx_t (size, elemt[i - 1], elemt[i])].num;
      else
	val_t = draw->vector[ls_oset_idx_t (size, elemt[i], elemt[i - 1])].num;
      if (! val_t)
	partid++;
      fm_vector_assign_int_idx (v, partid, elemt[i]);
    }
/*   printf ("output vector: "); fm_vector_print (stdout, v); printf ("\n"); */
/*   printf ("draw: "); fm_vector_print (stdout, draw); printf ("\n"); */

  // Do a safety check if the vector is not too large.
  if (draw->size < 300)
    {
      s_fm_vector_t* v2 = ls_oset_convert_ordering_pip (draw, size);
/*       printf ("PIP output vector: "); fm_vector_print (stdout, v2); printf ("\n"); */
      assert (fm_vector_equal (v, v2));
      if (v2)
	fm_vector_free (v2);
    }

  return v;
}


s_fm_vector_t*
ls_oset_convert_ordering_pip (s_fm_vector_t* draw, int size)
{
  int it, i, j, type;
  s_fm_vector_t* v = NULL;
  s_fm_vector_t* cst;
  int n = size;
  int offset = (n * (n - 1) ) / 2;
  s_fm_system_t* syst = fm_system_alloc (0, size + 2);
  for (it = 1; it <= draw->size / 2; ++it)
    {
      cst =  fm_vector_alloc (syst->nb_cols);
      val_of (n, it, &i, &j, &type);
      assert (i < cst->size);
      assert (j < cst->size);
      if (draw->vector[it].num == 1)
	{
	  fm_vector_set_ineq (cst);
	  fm_vector_assign_int_idx (cst, -1, i);
	  fm_vector_assign_int_idx (cst, 1, j);
	  fm_vector_assign_int_idx (cst, -1, cst->size - 1);
	  fm_system_add_line (syst, cst);
	}
      else if (draw->vector[it + offset].num == 1)
	{
	  fm_vector_assign_int_idx (cst, -1, i);
	  fm_vector_assign_int_idx (cst, 1, j);
	  fm_system_add_line (syst, cst);
	}
      else
	{
	  fm_vector_set_ineq (cst);
	  fm_vector_assign_int_idx (cst, -1, j);
	  fm_vector_assign_int_idx (cst, 1, i);
	  fm_vector_assign_int_idx (cst, -1, cst->size - 1);
	  fm_system_add_line (syst, cst);
	}
    }
  PipQuast* quast = fm_piptools_pip (syst, NULL, FM_PIPTOOLS_INT);
  if (quast == NULL || quast->list == NULL)
    return NULL;
  else
    {
      PipList* l = quast->list;
      v = fm_vector_alloc (size + 1);
      for (i = 1; l; l = l->next, ++i)
	{
	  assert (i < v->size);
	  fm_vector_assign_int_idx (v, l->vector->the_vector[0], i);
	}
    }
  pip_quast_free (quast);
  fm_system_free (syst);

  return v;
}
