#! /bin/sh


if [ $# -ne 4 ]; then
    echo "Usage: ./onetest.sh filename.cloog \"compile_cmd\" filename.candl transfo_dir"
    exit 1
fi


if [ -z "$LETSEEDIR" ]; then
    LETSEEDIR=".";
fi;


## Set cloog binary.
cloog="cloog -esp 1 -compilable 1"
#cloog="cloog"
filename="$1"
compile_line="$2"
origb=`basename $3`
transformations="$4"

FILENAME=${filename%.cloog};
orig=${origb%.candl};
source_program=${3%$origb}

if [ -z "$CLOOG" ]; then
    CLOOG="$cloog";
fi


## CLooG and post-process the transformation.
rm -f $FILENAME.c
CLOOG=$CLOOG $LETSEEDIR/src/scripts/cloog2test/cloog2test -sctp "$source_program/$orig.program" "$filename";

## Run the program, and check its output.
$compile_line -lm "$FILENAME.c" -o "$FILENAME"; #&>/dev/null;
if [ "$LETSEEDIR" = "." ]; then
    output_prg=`./$FILENAME`;
else
    output_prg=`$FILENAME`;
fi
if [ $? -ne 0 ]; then
    rm -f $FILENAME.output
    echo "SEGV: $FILENAME"
    exit 2
fi

## NOTE: Enabling this code fragment must be done with care:
## due to imprecision of floating point computation, a tiny
## difference may occur while the code would still be correct.
#	the_diff=`diff ./$target.output ./$TRANSFO_PATH/$orig_target.output`;
# if [ "$LETSEEDIR" = "." ]; then
#     the_diff=`diff ./$FILENAME.output $transformations/$orig.output`;
# else
#     the_diff=`diff $FILENAME.output $transformations/$orig.output`;
# fi
# if ! [ -z "$the_diff" ]; then
#    echo  "DIFF: $FILENAME"
#    exit 3
# #echo -n ""
# else
   rm -f $FILENAME.output
# fi

## Gather the results.
prg_idx=`echo "$FILENAME" | sed "s/.*_\(.*\)/\1/g"`;
prg_cycles=`echo "$output_prg" | grep Cycles |cut -d : -f 2 | cut -d ' ' -f 2`;

echo "$prg_cycles"
