#! /bin/sh


if [ $# -ne 3 ]; then
    echo "Usage: ./origtest.sh transfo_dir \"compile_cmd\" orig"
    exit 1
fi


## Set cloog binary.
cloog="cloog -esp 1"
transfo_dir="$1"
compile_line="$2"
origb=`basename $3`
orig=${origb%.candl};
source_program=${3%$origb}

## Unused now.
# ## CLooG and post-process the transformation.
# if [ -f "$source_program/$orig.cloog" ]; then
#     cp "$source_program/$orig.cloog" "$transfo_dir"
#     CLOOG=$CLOOG src/scripts/cloog2test/cloog2test -sctp "$source_program/$orig.program" "$transfo_dir/$orig.cloog";
# fi

## Run the program, and check its output.
$compile_line -lm "$transfo_dir/$orig.c" -o "$transfo_dir/$orig";# &>/dev/null;
output_prg=`./$transfo_dir/$orig`;
if [ $? -ne 0 ]; then
    rm -f $transfo_dir/$orig
    exit $?
fi


## Gather the results.
prg_cycles=`echo "$output_prg" | grep Cycles |cut -d : -f 2 | cut -d ' ' -f 2`;

echo "$prg_cycles"
