/*
 * matrix_to_past.h: This file is part of the IR-Converter project.
 *
 * IR-Converter: a library to convert PAST to ScopLib
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 *
 */
#ifndef IRCONVERTER_MATRIX_TO_PAST_H
# define IRCONVERTER_MATRIX_TO_PAST_H


# include <past/past.h>

# ifndef SCOPLIB_INT_T_IS_LONGLONG
#  define SCOPLIB_INT_T_IS_LONGLONG
# endif
# define LINEAR_VALUE_IS_LONGLONG
# include <scoplib/scop.h>


BEGIN_C_DECLS


extern
s_past_node_t*
irconverter_access_func_to_past (scoplib_matrix_p mat,
				 char** iterators,
				 int nb_iterators,
				 char** parameters,
				 int nb_parameters,
				 char** arrays,
				 int data_is_char);



END_C_DECLS


#endif // IRCONVERTER_MATRIX_TO_PAST_H
