/*
 * stack.c: This file is part of the IR-Converter project.
 *
 * IR-Converter: a library to convert PAST to ScopLib
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 *
 */
#if HAVE_CONFIG_H
# include <irconverter/config.h>
#endif

#include <assert.h>

#include <irconverter/common.h>
#include <irconverter/stack.h>

static
s_stack_t*
stack_alloc_elt ()
{
  s_stack_t* ret = XMALLOC(s_stack_t, 1);
  ret->data = NULL;
  ret->next = NULL;

  return ret;
}

void
stack_push (s_stack_t** stack, void* data)
{
  assert (stack);
  s_stack_t* elt = stack_alloc_elt ();
  elt->data = data;
  if (*stack != NULL)
    elt->next = *stack;
  *stack = elt;
}


void*
stack_pop (s_stack_t** stack)
{
  assert (stack);
  if (! *stack)
    return NULL;
  void* ret = (*stack)->data;
  s_stack_t* next = (*stack)->next;
  XFREE(*stack);
  *stack = next;
  
  return ret;
}


int
stack_size (s_stack_t** stack)
{
  assert (stack);
  int count;
  s_stack_t* tmp;
  for (count = 0, tmp = *stack; tmp; tmp = tmp->next, ++count)
    ;

  return count;
}


s_stack_t*
stack_contains (s_stack_t** stack, void* data)
{
  assert (stack);
  if (! *stack)
    return NULL;
  s_stack_t* tmp;
  for (tmp = *stack; tmp; tmp = tmp->next)
    if (tmp->data == data)
      return tmp;

  return NULL;
}


void
stack_free (s_stack_t** stack)
{
  if (! stack)
    return;
  while (*stack)
    {
      s_stack_t* next = (*stack)->next;
      XFREE (*stack);
      *stack = next;
    }
}
