/*
 * polyfeatures.h: this file is part of the PolyFeat project.
 *
 * PolyFeat, a Polyhedral Feature extractor
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */
#ifndef POLYFEAT_POLYFEATURES_H
# define POLYFEAT_POLYFEATURES_H

#include <polyfeat/common.h>


# ifndef LINEAR_VALUE_IS_LONGLONG
#  define LINEAR_VALUE_IS_LONGLONG
# endif
# ifndef SCOPLIB_INT_T_IS_LONGLONG
#  define SCOPLIB_INT_T_IS_LONGLONG
# endif
# include <scoplib/scop.h>


BEGIN_C_DECLS


struct s_polyfeat_dep
{
  int depth;    // dep->depth
  int dim;      // dimensionality of the dependence polyhedron.
  int self;	// 1 if within the same statement, 0 otherwise
  int type;	// 1: RAW, 2: WAR, 3: WAW, 4: RAR
  int kind;	// 1: uniform, 2: non-uniform, 3: parametric
};
typedef struct s_polyfeat_dep s_polyfeat_dep_t;



s_polyfeat_dep_t* polyfeat_dep_alloc();
void polyfeat_dep_free(s_polyfeat_dep_t* f);
void polyfeat_dep_print(FILE* outfile, s_polyfeat_dep_t* f);




END_C_DECLS


#endif // POLYFEAT_POLYFEATURES_H
