/******************************************************************************
 *                     PIP : Parametric Integer Programming                   *
 ******************************************************************************
 *                                  maind.h                                   *
 ******************************************************************************
 *                                                                            *
 * Copyright Paul Feautrier, 1988-2005                                        *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it under the  *
 * terms of the GNU General Public License as published by the Free Software  *
 * Foundation; either version 2 of the License, or (at your option) any later *
 * version.                                                                   *
 *                                                                            *
 * This software is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with software; if not, write to the Free Software Foundation, Inc.,        *
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA                     *
 *                                                                            *
 * Written by Paul Feautrier                                                  *
 *                                                                            *
 ******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>
#ifdef __TURBOC__
#include <dir.h>
#endif
#define min(x,y) ((x) < (y)? (x) : (y))

#include <piplib-gmp/piplib-gmp.h>

#ifndef PIPMP_LINEAR_VALUE_IS_MP
# define PIPMP_LINEAR_VALUE_IS_MP
#endif


#ifdef UNIX
#include <sys/times.h>
struct tms chrono;
#endif

char pipmp_version[]="Version E.2 $Revision: 1.3 $\n";

extern long int pipmp_cross_product, pipmp_limit ;
extern int pipmp_allocation, pipmp_comptage, pipmp_verbose ;
extern FILE * pipmp_dump ;
extern int pipmp_compa_count ;
extern char pipmp_dump_name[] ;
extern int pipmp_deepest_cut;

static
void balance(FILE *foo, FILE *bar)
{
 int level = 0;
 int c;
 while((c = pipmp_dgetc(foo)) != EOF)
     {
      switch(c)
	  {case '(' : level++; break;
	   case ')' : if(--level == 0) return;
	  }
      putc(c, bar);
     }
}

static
void escape(FILE *foo, FILE *bar, int level)
{int c;
 while((c = pipmp_dgetc(foo)) != EOF)
   switch(c)
     {case '(' : level ++; break;
     case ')' : if(--level == 0)
		     { fprintf(bar, "\nSyntax error\n)\n");
		       return;
		     }
     }
}

char * getenv();

int main(int argc, char *argv[])
{
 FILE *in, *out;
 TableauMP *ineq, *context, *ctxt;
 int nvar, nparm, ni, nc, bigparm;
 int nq; char * g;
 int simple = 0;
 struct pipmp_high_water_mark hq;
 int c, non_vide;
 int p, q, xq;
 long temps;
 char *date;
 EntierMP x ;
 #if defined(PIPMP_LINEAR_VALUE_IS_MP)
 mpz_init(x);
 #else
 EntierMP i;
 #endif
 
 #if defined(PIPMP_LINEAR_VALUE_IS_MP)
 mpz_init_set_si(pipmp_UN, 1);
 mpz_init_set_si(pipmp_ZERO, 0);
 #else
 pipmp_UN   = VAL_UN ;
 pipmp_ZERO = VAL_ZERO ;
 #endif
 
 in = stdin; out = stdout;
 p = 1;
 if(argc > 1)
 { if(strcmp(argv[1], "-s") == 0)
	 { pipmp_verbose = -1;
	   p = 2;
	 }
   /* the number of 'v' in the pipmp_verbose option control the amount of debug
    * information generated by Pip.
    */
   else
	 if(strncmp(argv[1], "-v", 2) == 0)
   { pipmp_verbose = 1;
     g = argv[1]+2;
     while(*g++ == 'v') pipmp_verbose++;
	  
     p = 2;
     g = getenv("DEBUG");
     if(g && *g)
     { pipmp_dump = fopen(g, "w");
       if(pipmp_dump == NULL)
       { fprintf(stderr, "%s unaccessible\n", g);
         pipmp_verbose = 0;
       }
     }
     else
     { mkstemp(pipmp_dump_name);
       pipmp_dump = fopen(pipmp_dump_name, "w");
     }
   }
   if(argc>p && strcmp(argv[p], "-d") == 0)
   { pipmp_deepest_cut = 1;
     p++;
   }
 }
	
 if(pipmp_verbose >= 0) fprintf(stderr, pipmp_version);
 if(argc > p)
 { if(strcmp(argv[p], "-z") == 0)
   { simple = 1;
     p++;
   }
   
	 in = fopen(argv[p], "r");
   if(in == NULL)
   { fprintf(stderr, "%s unaccessible\n", argv[p]);
     exit(1);
   }
 }
 p++;
 if(argc>p)
 { out = fopen(argv[p], "w");
   if(out == NULL)
   { fprintf(stderr, "%s unaccessible\n", argv[p]);
     exit(2);
   }
 }
 
 pipmp_limit = 0L;
 p++;
 if(argc > p) pipmp_limit = atol(argv[p]);
 solmp_init();
 tabmp_init();
 while((c = pipmp_dgetc(in)) != EOF)
     {if(c != '(') continue;
      fprintf(out, "(");
      balance(in, out);
      #if defined(PIPMP_LINEAR_VALUE_IS_MP)
      if(pipmp_dscanf(in, x) < 0){escape(in, out, 1); continue;}
      else
        nvar = mpz_get_si(x);
      if(pipmp_dscanf(in, x) < 0){escape(in, out, 1); continue;}
      else
        nparm = mpz_get_si(x);
      if(pipmp_dscanf(in, x) < 0){escape(in, out, 1); continue;}
      else
        ni = mpz_get_si(x);
      if(pipmp_dscanf(in, x) < 0){escape(in, out, 1); continue;}
      else
        nc = mpz_get_si(x);
      if(pipmp_dscanf(in, x) < 0){escape(in, out, 1); continue;}
      else
        bigparm = mpz_get_si(x);
      if(pipmp_dscanf(in, x) < 0){escape(in, out, 1); continue;}
      else
        nq = mpz_get_si(x);
      #else
      if(pipmp_dscanf(in, &x) < 0){escape(in, out, 1); continue;}
      else 
        nvar = (int) x;
      if(pipmp_dscanf(in, &x) < 0){escape(in, out, 1); continue;}
      else
        nparm = (int) x;
      if(pipmp_dscanf(in, &x) < 0){escape(in, out, 1); continue;}
      else 
        ni = (int) x;
      if(pipmp_dscanf(in, &x) < 0){escape(in, out, 1); continue;}
      else
        nc = (int) x;
      if(pipmp_dscanf(in, &x) < 0){escape(in, out, 1); continue;}
      else 
        bigparm = (int) x;
      if(pipmp_dscanf(in, &x) < 0){escape(in, out, 1); continue;}
      else 
        nq = (int) x;
      #endif
      
      if(pipmp_verbose > 0) {fprintf(pipmp_dump, "%d %d %d %d %d %d\n",nvar, nparm, ni, nc,
                               bigparm, nq);
                       fflush(pipmp_dump);
                      }
      pipmp_cross_product = 0;
      hq = tabmp_hwm();
      if(pipmp_verbose > 0) {fprintf(pipmp_dump, "hwm %lx\n", (unsigned long int) g);
                       fflush(pipmp_dump);
                      }
      ineq = tabmp_get(in, ni, nvar+nparm+1, nvar);
      if(ineq == NULL){escape(in, out, 2); continue;}
      context = tabmp_get(in, nc, nparm+1, 0);
      if(ineq == NULL){escape(in, out, 2); continue;}
      xq = p = solmp_hwm();
/* verification de la non-vacuite' du contexte */
      if(nc)
      {ctxt = pipmp_expanser(context, nparm, nc, nparm+1, nparm, 0, 0);
       pipmp_traiter(ctxt, NULL, Pip_True, nparm, 0, nc, 0, -1);
       non_vide = pipmp_is_not_Nil(p);
       solmp_reset(p);
      }
      else non_vide = Pip_True;
      if(non_vide) {
       pipmp_compa_count = 0;
       pipmp_traiter(ineq, context, nq, nvar, nparm, ni, nc, bigparm);
       putc(' ',out);
#if defined(PIPMP_LINEAR_VALUE_IS_MP)
       mpz_out_str(out, 10, ineq->determinant);
#else
       for(i=0; i<ineq->l_determinant; i++) {
        fprintf(out, FORMAT, ineq->determinant[i]);
        fprintf(out, " ");
       }
#endif
       fputs(" )",out);
       if(simple) solmp_simplify(xq);
       q = solmp_hwm();
       while((xq = solmp_edit(out, xq)) != q);
       solmp_reset(p);
      }
      else fprintf(out, "void\n");
      tabmp_reset(hq);
      if(pipmp_verbose > 0) fflush(pipmp_dump);
      /* add a right parenthesis in order to keep the output in balance */
      fprintf(out, ")\n");
      fflush(out);
      if(pipmp_verbose >= 0) 
       fprintf(stderr,"cross : %ld, alloc : %d, compa : %d\n\r",
               pipmp_cross_product, pipmp_allocation, pipmp_compa_count);
      pipmp_comptage++;
     }
#ifdef UNIX
 times(& chrono);
 fprintf(stderr, "n %d u %d''' s %d'''\r\n",
 pipmp_comptage, chrono.tms_utime, chrono.tms_stime);
#endif

#if defined(PIPMP_LINEAR_VALUE_IS_MP)
 mpz_clear(x);
#endif
 pipmp_close();
 exit(0);
}

