/*
 * depgraph.h: this file is part of the PolyFeat project.
 *
 * PolyFeat, a Polyhedral Feature extractor
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */
#ifndef POLYFEAT_DEPGRAPH_H
# define POLYFEAT_DEPGRAPH_H

# include <polyfeat/common.h>


# ifndef LINEAR_VALUE_IS_LONGLONG
#  define LINEAR_VALUE_IS_LONGLONG
# endif
# ifndef SCOPLIB_INT_T_IS_LONGLONG
#  define SCOPLIB_INT_T_IS_LONGLONG
# endif
# include <scoplib/scop.h>

# include <polyfeat/polyfeatures.h>


BEGIN_C_DECLS


void
polyfeat_depgraph_extract(FILE* outfile, scoplib_scop_p scop, int use_rar);


END_C_DECLS


#endif // POLYFEAT_DEPGRAPH_H
