/*
 * polyfeatures.c: this file is part of the PolyFeat project.
 *
 * PolyFeat, a Polyhedral Feature extractor
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#if HAVE_CONFIG_H
# include <polyfeat/config.h>
#endif

#include <polyfeat/polyfeatures.h>



s_polyfeat_dep_t*
polyfeat_dep_alloc()
{
  s_polyfeat_dep_t* ret = XMALLOC(s_polyfeat_dep_t, 1);

  ret->depth = 0;
  ret->dim = 0;
  ret->self = 0;
  ret->type = 0;
  ret->kind = 0;

  return ret;
}


void
polyfeat_dep_free(s_polyfeat_dep_t* f)
{
  XFREE(f);
}


void
polyfeat_dep_print(FILE* outfile, s_polyfeat_dep_t* f)
{
  fprintf (outfile, "%d %d %d %d %d",
	   f->depth, f->dim, f->self, f->type, f->kind);
}

