/*
 * xstrdup.c: this file is part of the PolyFeat project.
 * 
 * PolyFeat, a Polyhedral Feature extractor
 * 
 * Copyright (C) 2009 Louis-Noel Pouchet
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 */
#ifndef WITH_DMALLOC

#if HAVE_CONFIG_H
#  include <polyfeat/config.h>
#endif

#include <polyfeat/common.h>

char *
xstrdup (const char *string)
{
  return string ? strcpy (xmalloc (strlen (string) + 1), string) : NULL;
}

#endif /* !WITH_DMALLOC */
