dnl
dnl pluto.m4
dnl 
dnl PLUTO - parallelism and locality transformer (experimental)
dnl 
dnl Copyright (C) 2007-2008 Uday Bondhugula
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License
dnl as published by the Free Software Foundation; either version 2
dnl of the License, or (at your option) any later version.
dnl
dnl The complete GNU General Public Licence Notice can be found as the
dnl `COPYING' file in the top-level directory.
dnl


AC_DEFUN([PLUTO_ARG_LIBS_DEPENDENCIES],
[
dnl Add $prefix to the library path (convenience).
  if test -e ${prefix}/include; then
    CPPFLAGS="${CPPFLAGS} -I${prefix}/include"
    CFLAGS="${CFLAGS} -I${prefix}/include"
  fi;
  if test -e ${prefix}/lib; then
    LDFLAGS="${LDFLAGS} -L${prefix}/lib"
  fi;
dnl Offer --with-scoplib.
  AC_ARG_WITH(scoplib,
	      AC_HELP_STRING([--with-scoplib=DIR],
              	             [DIR Location of ScopLib package]),
              [with_scoplib=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_scoplib=yes])
dnl Check for scoplib existence.
  AS_IF([test "x$with_scoplib" != xno],
	[AC_SEARCH_LIBS([scoplib_scop_read], [scoplib], 
	 [LIBS="-lscoplib $LIBS";
	  AC_DEFINE([HAVE_LIBSCOPLIB], [1], [Define if you have libscoplib])
         ],
         [if test "x$with_scoplib" != xcheck; then
           AC_MSG_FAILURE([Test for ScopLib failed. Use --with-scoplib to specify libfm path.])
          fi
         ])
	])
dnl Offer --with-clan.
  AC_ARG_WITH(clan,
	      AC_HELP_STRING([--with-clan=DIR],
              	             [DIR Location of Clan package]),
              [with_clan=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_clan=yes])
dnl Check for clan existence.
  AS_IF([test "x$with_clan" != xno],
	[AC_SEARCH_LIBS([clan_parse], [clan], 
	 [LIBS="-lclan $LIBS";
	  AC_DEFINE([HAVE_LIBCLAN], [1], [Define if you have libclan])
         ],
         [if test "x$with_clan" != xcheck; then
           AC_MSG_FAILURE([Test for Clan failed. Use --with-clan to specify libfm path.])
          fi
         ])
	])
dnl Offer --with-pocc-utils.
  AC_ARG_WITH(pocc-utils,
	      AC_HELP_STRING([--with-pocc-utils=DIR],
              	             [DIR Location of pocc-utils package]),
              [with_pocc_utils=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_pocc_utils=check])
dnl Check for pocc-utils existence.
  AS_IF([test "x$with_pocc_utils" != xno],
	[AC_SEARCH_LIBS([pocc_utils_options_malloc], [pocc-utils], 
	 [LIBS="-lpocc-utils $LIBS";
	  AC_DEFINE([HAVE_LIBPOCC_UTILS], [1], [Define if you have libpocc-utils])
         ],
         [if test "x$with_pocc_utils" != xcheck; then
           AC_MSG_FAILURE([Test for POCC-UTILS failed. Use --with-pocc-utils to specify libpocc-utils path.])
          fi
         ])
	])
dnl Offer --with-piplib.
  AC_ARG_WITH(piplib,
	      AC_HELP_STRING([--with-piplib=DIR],
              	             [DIR Location of PipLib package]),
              [with_piplib=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_piplib=check])
dnl Check for piplib existence.
  AS_IF([test "x$with_piplib" != xno],
	[AC_SEARCH_LIBS([pip_solve], [piplib64], 
	 [LIBS="-lpiplib64 $LIBS";
	  AC_DEFINE([HAVE_LIBPIPLIB], [1], [Define if you have libpiplib64])
         ],
         [if test "x$with_piplib" != xcheck; then
           AC_MSG_FAILURE([--with-piplib was given, but test for piplib failed])
          fi
         ])
	])
dnl Offer --with-piplib-gmp.
  AC_ARG_WITH(piplib-gmp,
	      AC_HELP_STRING([--with-piplib-gmp=DIR],
              	             [DIR Location of PipLib-GMP package]),
              [with_piplib=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_piplib_mp=check])
dnl Check for piplib-gmp existence.
  AS_IF([test "x$with_piplib_mp" != xno],
	[AC_SEARCH_LIBS([pipmp_solve], [piplib-gmp], 
	 [LIBS="-lpiplib-gmp $LIBS";
	  AC_DEFINE([HAVE_LIBPIPLIB], [1], [Define if you have libpiplib-gmp])
	  AC_DEFINE([PLUTO_PIPSOLVE_WIDTH_MP], [1], [Define if you have libpiplib-gmp])
         ],
         [if test "x$with_piplib_mp" != xcheck; then
           AC_MSG_FAILURE([--with-piplib-gmp was given, but test for piplib-gmp failed])
          fi
         ])
	])
dnl Offer --with-candl.
  AC_ARG_WITH(candl,
	      AC_HELP_STRING([--with-candl=DIR],
              	             [DIR Location of CANDL package]),
              [with_candl=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_candl=yes])
dnl Check for candl existence.
  AS_IF([test "x$with_candl" != xno],
	[AC_SEARCH_LIBS([candl_dependence], [candl], 
	 [LIBS="-lcandl $LIBS";
	  AC_DEFINE([HAVE_LIBCANDL], [1], [Define if you have libcandl])
         ],
         [if test "x$with_candl" != xcheck; then
           AC_MSG_FAILURE([Test for Candl failed. Use --with-candl to specify libcandl path.])
          fi
         ])
	])
dnl Offer --with-cloog.
  AC_ARG_WITH(cloog,
	      AC_HELP_STRING([--with-cloog=DIR],
              	             [DIR Location of Cloog package]),
              [with_cloog=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_cloog=yes])
dnl Check for cloog existence.
  AS_IF([test "x$with_cloog" != xno],
	[AC_SEARCH_LIBS([cloog_program_generate], [cloog-isl], 
	 [LIBS="-lcloog-isl $LIBS";
	  AC_DEFINE([HAVE_LIBCLOOG], [1], [Define if you have libcloog-polylib])
         ],
         [if test "x$with_cloog" != xcheck; then
           AC_MSG_FAILURE([--with-cloog was given, but test for cloog failed])
          fi
         ])
	])
dnl Offer --with-polylib.
  AC_ARG_WITH(polylib,
	      AC_HELP_STRING([--with-polylib=DIR],
              	             [DIR Location of Polylib package]),
              [with_polylib=$withval;
	       if test x$withval != xno; then
  	         CPPFLAGS="${CPPFLAGS} -I$withval/include";
	         LDFLAGS="${LDFLAGS} -L$withval/lib";
               fi
	      ],
              [with_polylib=check])
dnl Check for polylib existence.
  AS_IF([test "x$with_polylib" != xno],
	[AC_SEARCH_LIBS([ConstraintSimplify], [polylib64], 
	 [LIBS="-lpolylib64 $LIBS";
	  AC_DEFINE([HAVE_LIBPOLYLIB], [1], [Define if you have libpolylib64])
         ],
         [if test "x$with_polylib" != xcheck; then
           AC_MSG_FAILURE([--with-polylib was given, but test for polylib failed])
          fi
         ])
	])
dnl Offer --with-gmp-include.
  AC_ARG_WITH(gmp-prefix,
	      AC_HELP_STRING([--with-gmp-prefix=DIR],
              	             [DIR Location of GMP package (only headers are needed)]),
              [CPPFLAGS="${CPPFLAGS} -I$withval/include";
	      ])

dnl Offer --with-polylib-gmp.
  AC_ARG_WITH(polylib-gmp,
	      AC_HELP_STRING([--with-polylib-gmp=DIR],
              	             [DIR Location of Polylibgmp package]),
              [with_polylibgmp=$withval;
	       if test x$withval != xno; then
	       	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       	       LDFLAGS="${LDFLAGS} -L$withval/lib";
               fi
	      ],
              [with_polylibgmp=check])
dnl Check for polylibgmp existence.
  AS_IF([test "x$with_polylibgmp" != xno],
	[AC_SEARCH_LIBS([ConstraintSimplify], [polylibgmp], 
	 [LIBS="-lpolylibgmp $LIBS";
	  AC_DEFINE([HAVE_LIBPOLYLIB_GMP], [1], [Define if you have libpolylibgmp])
         ],
         [if test "x$with_polylibgmp" != xcheck; then
           AC_MSG_FAILURE([--with-polylib-gmp was given, but test for polylibgmp failed])
          fi
         ])
	])

])
