/*
 * list.h: this file is part of the Vectorizer project.
 * 
 * Vectorizer, a vectorization module.
 * 
 * Copyright (C) 2010 Louis-Noel Pouchet
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#ifndef VECTORIZER_LIST_H
# define VECTORIZER_LIST_H

# include <vectorizer/common.h>

BEGIN_C_DECLS

struct list
{
  void*		data;
  struct list*	next;
};

typedef struct list List;


extern List*	list_new(void *data);
extern List*	list_cons(List *head, List *tail);
extern List*	list_tail(List *head);
extern size_t	list_length(List *head);


END_C_DECLS


#endif // VECTORIZER_LIST_H
