/*
 * metrics.h: this file is part of the Vectorizer project.
 *
 * Vectorizer, a vectorization module.
 *
 * Copyright (C) 2010 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#ifndef VECTORIZER_METRICS_H
# define VECTORIZER_METRICS_H

# include <vectorizer/common.h>

# ifndef LINEAR_VALUE_IS_LONGLONG
#  define LINEAR_VALUE_IS_LONGLONG
# endif
# ifndef SCOPLIB_INT_T_IS_LONGLONG
#  define SCOPLIB_INT_T_IS_LONGLONG
# endif
# include <scoplib/scop.h>


struct s_vectorizer_metrics
{


  float		cost; /* Composite cost. */
};

typedef struct s_vectorizer_metrics s_vectorizer_metrics_t;



BEGIN_C_DECLS


extern
s_vectorizer_metrics_t*
vectorizer_metrics_malloc ();

extern
void
vectorizer_metrics_free (s_vectorizer_metrics_t* metrics);

extern
void
vectorizer_metrics_print (FILE* file, s_vectorizer_metrics_t* metrics,
			  scoplib_scop_p scop);


END_C_DECLS


#endif // VECTORIZER_METRICS_H
