/*
 * Expression.cpp: This file is part of the Parametric Tiling project.
 * 
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 * 
 * Copyright (C) 2010 Sanket Tavargeri
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 * 
 */

#if HAVE_CONFIG_H
# include <ptile/config.h>
#endif

# include <ptile/Expression.hpp>

  Expression::Expression(int size)
  {
    this->size = size;
    AllocateMemory();
  }

  Expression::Expression()
  {
    size = 1;
    AllocateMemory();
  }

  void Expression::AllocateMemory()
  {
    terms = new Term[size];
  }

  void Expression::CloneFrom(Expression expr)
  {
    this->size = expr.size;
    AllocateMemory();

    for (int i = 0; i < expr.size; i++)
      {
	terms[i].CloneFrom(expr.terms[i]);
      }//for (i = 0; i < expr.size; i++)
  }// void CloneFrom(Expression expr)

  int Expression::GetSize()
  {
    return size;
  }

  void Expression::Print()
  {
    //printf("Expression\n");
    //printf("size - %d\n", size);

    for (int i = 0; i < size; i++)
      {
	terms[i].Print();
      }// for i

       //printf("\n");
  }// Print()
