/*
 * InputReaderParser.cpp: This file is part of the Parametric Tiling project.
 * 
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 * 
 * Copyright (C) 2011 Sanket Tavargeri
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include<string>
#include<iostream>
#include<vector>
#include <set>
#include<sstream>


# include <ptile/InputReaderParser.hpp>

  void InputReaderParser::PrintTokens()
  {
    int i;
    //cout<<"Tokens:"<<endl;
    for (i = 0; i < tokens.size(); i++)
      {
	//cout<<tokens.at(i)<<" ";
      }//for (i = 0; i < tokens.size(); i++)
        
    //cout<<endl;
  }//void PrintTokens()
    
  void InputReaderParser::ReadInput(char *fileName)
  {
    FILE * pFile;
    int c;
    int n = 0;
    string token = "";  
   
    pFile=fopen (fileName,"r");
    if (pFile==NULL) perror ("Error opening file");
    bool comment = false;
    bool tokenBegun = false;
    do {
      c = fgetc (pFile);
      n++;
      // If the input character is a space and if the token has begun, then output the token
      // and reset the TokenBegun flag
      if (c == EOF || c == ' ' || c == '#' || c == '\n')
	{
	  // The token ends here if it has begun
	  if (c == '#')
	    {
	      comment = true;
	    }//if (c == '#')
                    
	  if (c == '\n')
	    {
	      comment = false;
	    }//if (c == '\n')
                    
	  if (tokenBegun == true)
	    {
	      // Output token here and reset the string
	      ////cout<<"Token: "<<token<<endl;
	      tokens.push_back(token);
	      token = "";
	      tokenBegun = false;
	    }//if (tokenBegun == true)
                     
	  // If the tokenBegun is false, do nothing
	}//if (c == ' ' || c == '#')
      else if (comment == false)
	{                                        
	  tokenBegun = true;                    
	  token.append(1, c);                    
	}//else for if (c == ' ' || c == '#')
    } while (c != EOF);
    fclose (pFile);
  
  }// void ReadInput()
			
  vector<Expression*>* InputReaderParser::ParseInput()
  {
    string language;
    string SCoP;
    int ContextRows, ContextColumns;
    int *Context;
    int ParamNamesSet;
    string *ParamNames;
    int NumberOfStatements;
    int NumberOfDomains;
    int DomainRows, DomainColumns;
    vector<Expression*> *exprs = NULL;
  
    // Pointer of pointers. Each pointer pointing to one statement information
    int **StatementDomains;
  
    int Options[3];
    int IteratorNamesSet;
    string *IteratorNames;
    int NumberOfScatteringFunctions;

    int NumberOfParameters = 0;
    int NumberOfIterators = 0;
  
    // Temporary variables
    int i, j, k, l;
    const char *temp;
  
    int counter = 0;  
  
    SCoP = tokens.at(counter++); // The first token is a "SCoP" string
    language = tokens.at(counter++);
    temp = tokens.at(counter++).c_str();
    ContextRows = atoi(temp);
    temp = tokens.at(counter++).c_str();
    ContextColumns = atoi(temp);

    //printf("ContextRows = %d\n", ContextRows);
    //printf("ContextColumns = %d\n", ContextColumns);  

    //Derived info
    NumberOfParameters = ContextColumns - 2;
  
  
    Context = new int[ContextRows*ContextColumns];
    // Read context
    for (i = 0; i < ContextRows; i++)
      {
	for (j = 0; j < ContextColumns; j++)
	  {
	    temp = tokens.at(counter++).c_str();
	    Context[GeneralUtilityClass::getIndex2D(i, j, ContextColumns)] = atoi(temp);
	  }//for j
      }//for i
  
    ParamNamesSet = atoi(tokens.at(counter++).c_str());
  
    if (ParamNamesSet)
      {
	// Number of parameters: (ContextColumns - 2)
	ParamNames = new string[ContextColumns - 2];
	for (i = 0; i < ContextColumns - 2; i++)
	  {
	    ParamNames[i] = tokens.at(counter++);
	  }// for i
      }//if (ParamNameSet)
  
    // Statements
    NumberOfStatements = atoi(tokens.at(counter++).c_str());
  
    // TODO : Handle multi domain case 
    StatementDomains = new int*[NumberOfStatements];
  
    for (i = 0; i < NumberOfStatements; i++)
      {
        NumberOfDomains = atoi(tokens.at(counter++).c_str());
        for (j = 0; j < NumberOfDomains; j++)
	  {
            DomainRows = atoi(tokens.at(counter++).c_str());
            DomainColumns = atoi(tokens.at(counter++).c_str());
			
			
	    // Allocate memory to store the matrix.
			
	    StatementDomains[i] = new int[NumberOfDomains*DomainRows*DomainColumns];		  						
            NumberOfIterators = DomainColumns - NumberOfParameters - 2;
						
            for (k = 0; k < DomainRows; k++)
	      {
                for (l = 0; l < DomainColumns; l++)
		  {
                    StatementDomains[i][GeneralUtilityClass::getIndex3D(j, k, DomainRows, l, DomainColumns)] 
		      = atoi(tokens.at(counter++).c_str());
		  }//for (l = 0; l < DomainColumns; l++)
	      }// for (k = 0; k < DomainRows; k++)
												
	  }//for (j = 0; j < NumberOfDomains; j++)
        
        
        // Scattering function information        
        int ScatteringFunctionPresent = atoi(tokens.at(counter++).c_str());
        
        if (ScatteringFunctionPresent)
	  {
            int ScatteringFunctionRows = atoi(tokens.at(counter++).c_str());
            int ScatteringFunctionColumns = atoi(tokens.at(counter++).c_str());
	    // Allocate memory to store the matrix.
            int *ScatteringFunctionList = new int[ScatteringFunctionRows*ScatteringFunctionColumns];

            for (k = 0; k < ScatteringFunctionRows; k++)
	      {
                for (l = 0; l < ScatteringFunctionColumns; l++)
		  {
                    ScatteringFunctionList[GeneralUtilityClass::getIndex2D(k, l, ScatteringFunctionColumns)] 
		      = atoi(tokens.at(counter++).c_str());
		  }//for (l = 0; l < DomainColumns; l++)
	      }// for (k = 0; k < DomainRows; k++)
                        
	  }//if (ScatteringFunctionPresent)


	/*Access information*/
        ScatteringFunctionPresent = atoi(tokens.at(counter++).c_str());        
        if (ScatteringFunctionPresent)
	  {
            /* Read access information*/
            int ScatteringFunctionRows = atoi(tokens.at(counter++).c_str());
            int ScatteringFunctionColumns = atoi(tokens.at(counter++).c_str());
	    // Allocate memory to store the matrix.
            int *ScatteringFunctionList = new int[ScatteringFunctionRows*ScatteringFunctionColumns];

            for (k = 0; k < ScatteringFunctionRows; k++)
	      {
                for (l = 0; l < ScatteringFunctionColumns; l++)
		  {
                    ScatteringFunctionList[GeneralUtilityClass::getIndex2D(k, l, ScatteringFunctionColumns)] 
		      = atoi(tokens.at(counter++).c_str());
		  }//for (l = 0; l < DomainColumns; l++)
	      }// for (k = 0; k < DomainRows; k++)

            /* Write access information*/
            ScatteringFunctionRows = atoi(tokens.at(counter++).c_str());
            ScatteringFunctionColumns = atoi(tokens.at(counter++).c_str());
	    // Allocate memory to store the matrix.
            ScatteringFunctionList = new int[ScatteringFunctionRows*ScatteringFunctionColumns];

            for (k = 0; k < ScatteringFunctionRows; k++)
	      {
                for (l = 0; l < ScatteringFunctionColumns; l++)
		  {
                    ScatteringFunctionList[GeneralUtilityClass::getIndex2D(k, l, ScatteringFunctionColumns)] 
		      = atoi(tokens.at(counter++).c_str());
		  }//for (l = 0; l < DomainColumns; l++)
	      }// for (k = 0; k < DomainRows; k++)
                        
	  }//if (ScatteringFunctionPresent)

        int StatementBodyPresent = atoi(tokens.at(counter++).c_str());

        IteratorNamesSet = 1;
        IteratorNames = new string[NumberOfIterators];
	for (i = 0; i < NumberOfIterators; i++)
	  {
	    IteratorNames[i] = tokens.at(counter++);
	  }//for (i = 0; i < NumberOfIterators; i++)
        
        if (StatementBodyPresent)
	  {
            string StatementBody = tokens.at(counter++).c_str();
	  }//if (StatementBodyPresent)
      }//for (i = 0; i < NumberOfStatements; i++)
  
    /*******************************************************************/
    for (i = 0; i < NumberOfStatements; i++)
      {
	// Form expressions			
	exprs = GeneralUtilityClass::FormExpressions(StatementDomains[i],
						     NumberOfDomains*DomainRows*DomainColumns, DomainRows, DomainColumns, 
						     NumberOfIterators, NumberOfParameters, 
						     ParamNamesSet, ParamNames, IteratorNamesSet, IteratorNames);
      }
 
    return exprs;
  }//void ParseInput()


