/*
 * RSFME.cpp: This file is part of the Parametric Tiling project.
 * 
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 * 
 * Copyright (C) 2011 Sanket Tavargeri
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 * 
 */


#include <stdio.h>
#include <stdlib.h>
#include<string>
#include<iostream>
#include<vector>
#include <set>
#include<sstream>

# include <ptile/RSFME.hpp>

   vector<Expression*>* RSFME::InterleaveLnUn(vector<Expression> Ln, vector<Expression> Un)
  {
    vector<Expression*>* combinedExpressions = new vector<Expression*>();
    assert(Ln.size() == Un.size());
    for (int i = Ln.size() - 1; i >= 0; i--)
      {
	Expression* expr1 = new Expression;
	expr1->CloneFrom(Ln.at(i));

	Expression* expr2 = new Expression;
	expr2->CloneFrom(Un.at(i));

	if (i == Ln.size() - 1)
	  {
	    combinedExpressions->push_back(expr2);
	    combinedExpressions->push_back(expr1);
	  }// if (i == Ln.size() - 1)
	else
	  {
	    combinedExpressions->push_back(expr1);
	    combinedExpressions->push_back(expr2);
	  }// else
      }// for (int i = 0; i < Ln.size(); i++)

    return combinedExpressions;
  }//  vector<Expression*>* InterleaveLnUn(vector<Expression> Ln, vector<Expression> Un)

   vector<Expression*>* RSFME::RunRSFME(vector<Expression> Lo, vector<Expression> Uo, vector<Expression> Lw,
				       vector<Expression> Uw, vector<Expression> MinValues, vector<Expression> MaxValues)
  {

    vector<Expression> Ln;
    vector<Expression> Un;
    
    // Add kt >= w - it - jt and kt <= w - it - jt
   
    Ln.push_back(Lw.at(0));
    Un.push_back(Uw.at(0));

    /*Process Lw and Uo. Start from the innermost expression corresponding to the innermost variable in Uo.
      Feed the resulting expression to the next step. */

    //cout<<"Combining Lw with Uo started"<<endl;
    Expression currentLw = Lw.at(Lw.size() - 1);
    for (int i = Uo.size() - 1; i >= 0; i--)
      {
        Expression expr = Uo.at(i);
        bool isResultNull;
	//cout<<"Adding 2 rows"<<endl;
        Expression res_expr = ExpressionLibrary::Add_Rows(currentLw, expr, &isResultNull);
	//cout<<"Adding 2 rows finished"<<endl;
	//cout<<"The sum is"<<endl;
	res_expr.Print();

	// No need to do this for the last step
	if (i != 0)
	  {
	    //cout<<"Calling SetSignOfRightMostLoopIterator()"<<endl;
	    ExpressionLibrary::SetSignOfRightMostLoopIterator(&res_expr, 1, MinValues, MaxValues);
	    //cout<<"SetSignOfRightMostLoopIterator() finished"<<endl;
	  }// if (i != 0) 
	else
	  {
	    ExpressionLibrary::SetCoefficientOfRightmostIteratorOne(&res_expr);
	  }//else

        if (!isResultNull)
	  {
            Ln.push_back(res_expr);
	  }// if (!isResultNull)

        currentLw = res_expr;
      }// for int i

    //cout<<"Combining Lw with Uo finished"<<endl;
    Expression currentUw = Uw.at(Uw.size() - 1);
    //cout<<"Current Uw"<<endl;
    currentLw.Print();
    for (int i = Lo.size() - 1; i >= 0; i--)
      {
        Expression expr = Lo.at(i);
        bool isResultNull;
	//cout<<"Adding 2 rows"<<endl;
	//cout<<"Expression 1"<<endl;
	currentLw.Print();
        //cout<<"Expression 2"<<endl;
        expr.Print();
        Expression res_expr = ExpressionLibrary::Add_Rows(currentUw, expr, &isResultNull);
        //cout<<"Resulting expression"<<endl;
        res_expr.Print();
	//cout<<"Adding 2 rows finished"<<endl;
        // Set the sign appropriately for all the expressions except for the last one

        // No need to do this for the last step
	if (isResultNull == false)
	  { 
	    if (i != 0)
	      {
		ExpressionLibrary::SetSignOfRightMostLoopIterator(&res_expr, -1, MinValues, MaxValues);
	      }// if (i != 0)
	    else
	      {
		ExpressionLibrary::SetCoefficientOfRightmostIteratorOne(&res_expr);
	      }//else
        
	    Un.push_back(res_expr);
	    currentUw = res_expr;
	  }// if (isResultNull == false)
      }// for int i

    vector<Expression*>* combinedExpressions = InterleaveLnUn(Ln, Un);
    return combinedExpressions;
  }//     vector<Expression*>* RunRSFME(vector<Expression> Lo, vector<Expression> Uo, vector<Expression> Lw, vector<Expression> Uw, vector<Expression> MinValues, vector<Expression> MaxValues)


