/*
 * Tiler.cpp: This file is part of the Parametric Tiling project.
 * 
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 * 
 * Copyright (C) 2011 Sanket Tavargeri
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 * 
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 * 
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 * 
 */


# include <ptile/Tiler.hpp>

        
  vector<Expression>* Tiler::ConstructLwUw(vector<Expression*> *exprs, int CoefficientOfFirstIterator, string name)
  {
    vector<Expression> *exprVec = new vector<Expression>();
    Expression LwUw;		
    Term *terms = new Term[exprs->at(0)->size];
    int count = 0;

    // InterTileIterators
    for (int j = 0; j < exprs->at(0)->size; j++)
      {
	terms[count++].SetIdentityTermFrom(exprs->at(0)->terms[j]);

	if (exprs->at(0)->terms[j].type == interTile_loop_iterator )
	  {	
	    if (j == 0)
	      {
		terms[count - 1].coefficient = CoefficientOfFirstIterator;
		terms[count - 1].name = name;
	      }// if (j == 0)
	    else
	      {
		terms[count - 1].coefficient = -1 * CoefficientOfFirstIterator;
	      }//else
				
	  }//if (exprs->at(i)->type == interTile_loop_iterator)
      }//for (int j = 0; j < exprs->at(i)->size; j++)

    LwUw.terms = terms;
    LwUw.size = exprs->at(0)->size;
			
    exprVec->push_back(LwUw);
    return exprVec;
  }// struct ConstructLw(vector<Expression*> *exprs)

  struct Tiler::RSFME_Expressions Tiler::PrepareRSFME_ExpressionsFromExpressions(vector<Expression*> *exprs)
  {		
    /*1. Constructing Lo. The expressions which have the right most iterator +ve
      2. Construcing Uo. The expressions which have the right most iterator -ve
      3. Add w iterator to all the expressions
      4. Constructing Lw. -w + i >=0. Equivalently w <= i
      5. Constructing Uw. w - i >=0. EquivalenOutputFiletly w >= i
    */

    struct RSFME_Expressions rsfme_expressions;

    //Introduce "w" term with coefficient 0
    //cout<<"Calling AddWInterTileLoopIteratorTermInExpression()"<<endl;
    //cout<<"Before adding the w term\n";
    ExpressionLibrary::PrintExpressions(exprs);
    ExpressionLibrary::AddWInterTileLoopIteratorTermInExpression(exprs, "wPTile");
    //printf("After adding w term\n");
    ExpressionLibrary::PrintExpressions(exprs);
    //cout<<"Call to AddWInterTileLoopIteratorTermInExpression() completed"<<endl;

    //cout<<"Separating Lo and Uo"<<endl;
    // Separate Lo and Uo
    vector<Expression> *Lo = new vector<Expression>();
    vector<Expression> *Uo = new vector<Expression>();
    for (int i = 0; i < exprs->size(); i++)
      {
	Expression *expr = exprs->at(i);
	Expression copyExpr;
	copyExpr.CloneFrom(*expr);
	float coefficient = ExpressionLibrary::GetCoefficientOfRightmostIterator(expr);
	//printf("coefficient = %f\n", coefficient);
	// Min value
	if (coefficient > 0)
	  {
	    Lo->push_back(copyExpr);
	  }// if (coefficient > 0)
	else if (coefficient < 0)
	  {
	    Uo->push_back(copyExpr);
	  }// else if (coefficient < 0)
	
      }// for (int i = 0; i < exprs->size(); i++)

    // Prepare Lw and Uw
    rsfme_expressions.Lo = Lo;
    rsfme_expressions.Uo = Uo;
    rsfme_expressions.Lw = ConstructLwUw(exprs, -1, "wPTile");
    rsfme_expressions.Uw = ConstructLwUw(exprs, 1, "wPTile");
		
    //cout<<"Separation of Lo, Uo finished. Returning"<<endl;
    //printf("Lo expressions\n");
    ExpressionLibrary::PrintExpressions(rsfme_expressions.Lo);	

    //printf("Uo expressions\n");
    ExpressionLibrary::PrintExpressions(rsfme_expressions.Uo);	

    //TODO: Insert the right min and max values
    rsfme_expressions.MinValues = Lo;
    rsfme_expressions.MaxValues = Uo;
    return rsfme_expressions;
  }// struct RSFME_Expressions PrepareRSFME_ExpressionsFromExpressions(vector<Expression*> *exprs)

   
  struct TileLoops Tiler::Tile(vector<Expression*> *exprs,
			s_ptile_options_t* ptileOptions)
  {
    TileLoops tileLoops;
    // Substitute each iterator i with i = it * Ti + ii
    ExpressionLibrary::SubstituteIteratorWithIteratorPlusTileSize(exprs);

    // Replace the IntraTile loop iterator ii with Ti - 1 if the coefficient of ii is positive.
    // If negative, make it 0
    ExpressionLibrary::ReplaceIntraTileIteratorWithBounds(exprs);

    if (ptileOptions->RSFME == 1)
      {
	//cout<<"Running RSFME"<<endl;
	/*RSFME sction begins*/
	RSFME_Expressions rsfme_expressions = PrepareRSFME_ExpressionsFromExpressions(exprs);	
        vector<Expression*> *rsfmeResultExpressions = RSFME::RunRSFME(*(rsfme_expressions.Lo), *(rsfme_expressions.Uo), *(rsfme_expressions.Lw), *(rsfme_expressions.Uw),
								      *(rsfme_expressions.MinValues), *(rsfme_expressions.MaxValues));

	ExpressionLibrary::ConvertExpressionsToInequalities(rsfmeResultExpressions);
	tileLoops.rsfmeLoops = ASTGenerator::GenerateTileLoops(rsfmeResultExpressions, ptileOptions);

	/*RSFME section ends*/
      }//if (ptileOptions.RSFME == 1)


    // Now bring the Expressions to inequality form
    // e.g for expression i - N >=0 produce i >= N
    // for expression -i + N >= 0 produce i <= N
    ExpressionLibrary::ConvertExpressionsToInequalities(exprs);

    //cout<<"Tile loops"<<endl;
    ExpressionLibrary::PrintExpressions(exprs);

    tileLoops.tileLoops = ASTGenerator::GenerateTileLoops(exprs, ptileOptions);

    return tileLoops;
  }// struct ext_clast_for* Tile(vector<Expression*> *exprs, struct clast_stmt** pointLoops)

