/*
 * TilingDriver.cpp: This file is part of the Parametric Tiling project.
 *
 * Parametric Tiling: A CLAST-to-CLAST parametric tiling software
 *
 * Copyright (C) 2011 Sanket Tavargeri
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include<string>
#include<iostream>
#include<vector>
#include <set>
#include<sstream>

# include <ptile/TilingDriver.hpp>

  
  void TilingDriver::traverse_for_replace (s_past_node_t* node, void* data)
  {
    void** args = (void**)data;
    if (*args != NULL && PAST_NODE_IS_A(node, past_for))
      {
	past_replace_node (node, (s_past_node_t*)*args);
	*args = NULL;
      }
  }


  
  void TilingDriver::traverse_for_find_first (s_past_node_t* node, void* data)
  {
    void** args = (void**)data;
    if (*args == NULL && PAST_NODE_IS_A(node, past_for))
	*args = node;
  }


  s_past_node_t* TilingDriver::ReplaceFirstForLoopNest(s_past_node_t* ast,
					 s_past_node_t* tiledCode)
  {
    if (PAST_NODE_IS_A(ast, past_for))
      return tiledCode;

    void* data = tiledCode;
    past_visitor (ast, traverse_for_replace, (void*)&data, NULL, NULL);
    return ast;
  }

  s_past_node_t* TilingDriver::FindFirstForLoop(s_past_node_t* s)
  {
    s_past_node_t* data = NULL;
    past_visitor (s, traverse_for_find_first, (void*)&data, NULL, NULL);

    return data;
  }


  // Input: Single for loop nest
  s_past_node_t* TilingDriver::DriveTiling(s_past_node_t* inputAST,
			     scoplib_scop_p program,
			     s_ptile_options_t* options, int nofuse)
  {
    if (options->verbose_level > 2)
      std::cout << "[PTile] Computing convex hull" << std::endl;
    scoplib_scop_p scopInputToTiling =
      ConvexHullFormer::CreateConvexHull(program);

    if (options->verbose_level > 2)
      std::cout << "[PTile] Convert convex hull to internal representation"
		<< std::endl;
    ScoplibToExpressionConverter scoplibToExpressionConverter;
    //printf("Calling scoplibToExpressionConverter\n");
    vector<Expression*> *exprs = scoplibToExpressionConverter.ReadAndParseScoplibToExpressions(scopInputToTiling);
    //printf("Returning from scoplibToExpressionConverter\n");

    s_past_node_t* pointForLoops = FindFirstForLoop(inputAST);
    s_past_node_t* tiledCode = DriveTiling(exprs, pointForLoops, options, nofuse);

    if (options->verbose_level > 2)
      std::cout << "[PTile] Inserting final code"
		<< std::endl;
    // Need to insert the tiledLoops in the appropriate position
    // printf ("Calling ReplaceFirstForLoopNest\n");
    s_past_node_t* outputAST = ReplaceFirstForLoopNest(inputAST, tiledCode);
    // printf ("Returned from ReplaceFirstForLoopNest\n");

    // return (struct ext_clast_stmt*) tiledLoops;
    return outputAST;
  }// void DriveTiling(scoplib_scop_p scoplibScop, struct clast_stmt **pointLoops)





  s_past_node_t* TilingDriver::DriveTiling(vector<Expression*> *exprs,
			     s_past_node_t* pointLoops,
			     s_ptile_options_t* options, int nofuse)
  {
    Tiler tiler;
    if (options->verbose_level > 2)
      std::cout << "[PTile] Generating tile loops" << std::endl;
    //printf("Calling Tiler.Tile()\n");
    struct TileLoops tileLoopsStruct = tiler.Tile(exprs, options);
    s_past_node_t* tileLoops = tileLoopsStruct.tileLoops;

    if (options->verbose_level > 2)
      std::cout << "[PTile] Inserting tile loops" << std::endl;
    TileLoopInserter tileLoopInserter;
    
    if (options->verbose_level > 3)
      {
	std::cout << "[PTile] Generated tile loops:" << std::endl;
	past_pprint (stdout, tileLoops);
      }

    s_past_node_t* tiledCode = NULL;

     if (nofuse == 1)
     {
	// printf ("Calling InsertTileLoopsInOriginalLoopOrder\n");
        tiledCode = tileLoopInserter.InsertTileLoopsInOriginalLoopOrder(pointLoops, tileLoopsStruct, options);
	// printf ("Returned from InsertTileLoopsInOriginalLoopOrder\n");
     }
    else
     {
	tiledCode = tileLoopInserter.InsertTileLoops(pointLoops, tileLoopsStruct, options);
     }
	

    // Apply the optimization:
    // Hoist the lowerbound & upperbound expressions for every for loop
    if (options->verbose_level > 2)
      std::cout << "[PTile] Optimizing generated code" << std::endl;
//    ASTOptimizer astOptimizer;
    s_past_node_t* ConditionalHoistedTiledCode = tiledCode;
//      astOptimizer.HoistExpressionsInForLoops(tiledCode);

  /*{
	FILE* fp = fopen ("Output.c", "a");
	past_pprint (fp, ConditionalHoistedTiledCode);
	fclose (fp);
  }*/

    return ConditionalHoistedTiledCode;
    // return tiledCode;
  }// void DriveTiling(vector<Expression*> *exprs, struct clast_stmt **pointLoops)
