/*
 * parametrictiling.cpp: This file is part of the PTile project.
 *
 * PTile: A PAST-to-PAST parametric tiling software
 *
 * Copyright (C) 2011 Sanket Tavargeri
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Sanket Tavargeri <sanket.tavargeri@gmail.com>
 *
 */

#if HAVE_CONFIG_H
# include <ptile/config.h>
#endif


#include <ptile/common.h>

#include <ptile/PTile.hpp>
#include <ptile/PtileClasses.hpp>


s_past_node_t*
parametricallytile(scoplib_scop_p program,
		   s_past_node_t* root,
		   s_ptile_options_t* options, int nofuse)
{
//  options->fullTileSeparation = 1;
//   printf ("Entered parametricallytile()\n");
/*{
   FILE *fp = fopen ("Input.c", "a");
   past_pprint (fp, root);
   fclose (fp);
}*/

  TilingDriver tilingDriver;

  s_past_node_t* tiledLoop = tilingDriver.DriveTiling(root, program, options, nofuse);

//   printf ("Leaving parametricallytile()\n");
/*{
   FILE *fp = fopen ("Output.c", "a");
   past_pprint (fp, tiledLoop);
   fclose (fp);
}*/

  return tiledLoop;
}
