/*
 * list.c: this file is part of the FM project.
 *
 * FM, a fast and optimized C implementation of Fourier-Motzkin
 * projection algorithm.
 *
 * Copyright (C) 2006,2007,2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 *  as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */

#include <fm/list.h>


s_fm_list_t*
fm_list_new (void *data)
{
  s_fm_list_t *res = XMALLOC (s_fm_list_t, 1);

  res->next = NULL;
  res->data = data;

  return res;
}


void fm_list_dummy_free (void* data)
{
}


void
fm_list_free (s_fm_list_t* l, free_fun_t f)
{
  s_fm_list_t* tmp;

  while (l != NULL)
    {
      f (l->data);
      tmp = l->next;
      XFREE(l);
      l = tmp;
    }
}


// FIXME: horrible and temporary.
int
fm_list_remove (s_fm_list_t** head, void* data)
{
  if (*head == NULL)
    return 1;

  s_fm_list_t* tmp;
  s_fm_list_t* pred;

  for (tmp = *head; tmp && tmp->data != data; tmp = tmp->next)
    pred = tmp;
  if (tmp == NULL)
    return 1;

  if (tmp == *head)
    *head = tmp->next;
  else
    pred->next = tmp->next;
  XFREE(tmp);

  return 0;
}


s_fm_list_t*
fm_list_add_head (s_fm_list_t** head, void* data)
{
  s_fm_list_t* tmp;

  if (*head == NULL)
    {
      *head = fm_list_new (data);
      return *head;
    }

  tmp = fm_list_new (data);
  tmp->next = *head;
  *head = tmp;

  return tmp;
}


s_fm_list_t*
fm_list_add_head_unique (s_fm_list_t** head, void* data, cmp_fun_t f)
{
  s_fm_list_t* tmp;

  if (*head == NULL)
    {
      *head = fm_list_new (data);
      return *head;
    }

  for (tmp = *head; tmp != NULL && ! f (tmp->data, data); tmp = tmp->next)
    ;

  if (tmp == NULL)
    {
      tmp = fm_list_new (data);
      tmp->next = *head;
      *head = tmp;
    }
  else
    tmp = *head;

  return tmp;
}


s_fm_list_t*
fm_list_cons (s_fm_list_t* head, s_fm_list_t* tail)
{
  head->next = tail;

  return head;
}


s_fm_list_t*
s_fm_list_tail (s_fm_list_t *head)
{
  return head->next;
}


size_t
fm_list_length (s_fm_list_t *head)
{
  size_t n;

  for (n = 0; head; ++n)
    head = head->next;

  return n;
}
