/*
 * fm_rational_test.c: this file is part of the FM project.
 *
 * FM, a fast and optimized C implementation of Fourier-Motzkin
 * projection algorithm.
 *
 * Copyright (C) 2006-2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 *  as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#if HAVE_CONFIG_H
# include <fm/config.h>
#endif

#include <stdio.h>
#include <fm/common.h>
#include <fm/rational.h>


int
main ()
{
  fprintf(stderr, "=> Testing rational class\n");
  fprintf(stderr, "* Allocation tests\n");
  s_fm_rational_t* r1 = fm_rational_alloc ();
  if (r1->num != 0 || r1->denum != 1)
    return 1;

  fprintf(stderr, "* Assignation tests\n");
#ifdef NDEBUG
  if (fm_rational_assign (r1, 1, 0) != 1)
    return 1;
#endif

  fm_rational_assign (r1, -1, 2);
  if (r1->num != -1 || r1->denum != 2)
    return 1;

  fm_rational_assign (r1, -1, -2);
  if (r1->num != 1 || r1->denum != 2)
    return 1;

  fm_rational_assign (r1, 1, -2);
  if (r1->num != -1 || r1->denum != 2)
    return 1;

  fprintf(stderr, "* Operators tests:\n");
  s_fm_rational_t* r2 = fm_rational_alloc ();
  s_fm_rational_t* r = fm_rational_alloc ();
  fm_rational_assign (r2, 1, 3);

  fprintf(stderr, "** ADD tests\n");
  fm_rational_add(r, r1, r2);
  if (r->num != -1 || r->denum != 6)
    return 1;

  fprintf(stderr, "** SUB tests\n");
  fm_rational_sub(r, r1, r2);
  if (r->num != -5 || r->denum != 6)
    return 1;

  fprintf(stderr, "** MUL tests\n");
  fm_rational_mul(r, r1, r2);
  if (r->num != -1 || r->denum != 6)
    return 1;

  fprintf(stderr, "** DIV tests\n");
  fm_rational_div(r, r1, r2);
  if (r->num != -3 || r->denum != 2)
    return 1;

  fprintf(stderr, "** OPP tests\n");
  fm_rational_opp(r, r1);
  if (r->num != 1 || r->denum != 2)
    return 1;

  fprintf(stderr, "** EQ tests\n");
  if (! fm_rational_equal(r1, r1))
    return 1;

  fprintf(stderr, "* Free tests\n");
  fm_rational_free (r);
  fm_rational_free (r1);
  fm_rational_free (r2);

  fprintf(stderr, "== All done for rational class.\n");

  return 0;
}
