/*
 * clast2scop.h: this file is part of the ScopTools project.
 *
 * ScopTools, a set of convenience functions to translate to/from ScopLib.
 *
 * Copyright (C) 2010 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#ifndef SCOPTOOLS_CLAST2SCOP_H
# define SCOPTOOLS_CLAST2SCOP_H

# include <scoptools/common.h>

# ifndef SCOPLIB_INT_T_IS_LONGLONG
#  define SCOPLIB_INT_T_IS_LONGLONG
# endif
# ifndef LINEAR_VALUE_IS_LONGLONG
#  define LINEAR_VALUE_IS_LONGLONG
# endif
# include <scoplib/scop.h>
# ifndef CLOOG_INT_GMP
#  define CLOOG_INT_GMP
# endif
# include <cloog/cloog.h>
# include <cloog/clast.h>


BEGIN_C_DECLS


extern
scoplib_scop_p
scoptools_clast2scop_rose (struct clast_stmt* s, scoplib_scop_p orig_scop);

extern
scoplib_scop_p
scoptools_clast2scop (struct clast_stmt* s, scoplib_scop_p orig_scop);

extern
struct clast_stmt*
scoptools_scop2clast (scoplib_scop_p scop);



END_C_DECLS


#endif // SCOPTOOLS_CLAST2SCOP_H
