/*
 * pprint.h: This file is part of the PAST project.
 *
 * PAST: the PoCC Abstract Syntax Tree
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 *
 */
#ifndef PAST_PPRINT_H
# define PAST_PPRINT_H

# include <stdio.h>
# include <past/past.h>


BEGIN_C_DECLS

typedef void (*past_metainfo_fun_t) (struct past_node_t* node, FILE* outfile);

/**
 * User-defined pretty-print function. Must return 1 if 'node' was
 * pretty-printed, 0 otherwise.
 *
 */
typedef int (*past_pprint_extensions_fun_t) (FILE* out, int indent,
					     s_past_node_t* node,
					     s_symbol_table_t* symboltable,
					     past_metainfo_fun_t mprint);
/**
 * Generic node C pretty-printer.
 *
 *
 */

extern
void
past_pprint_node (FILE* out, int indent,
		  s_past_node_t* node, s_symbol_table_t* symboltable,
		  past_metainfo_fun_t mprint,
		  past_pprint_extensions_fun_t past_pprint_ext);

/**
 * Default C pretty-printer.
 *
 *
 */
extern
void
past_pprint (FILE* out, s_past_node_t* root);


/**
 * C pretty-printer using 'mprint' to print meta-info, if any.
 * prototype: void mprint (s_past_node_t* node, FILE* out).
 *
 */
extern
void
past_pprint_metainfo (FILE* out, s_past_node_t* root,
		      past_metainfo_fun_t mprint);

/**
 * C pretty-printer using 'mprint' to print meta-info, if any.
 * prototype: void mprint (s_past_node_t* node, FILE* out).
 * Uses 'past_pprint_ext' to print user-defined nodes, if any.
 *
 */
extern
void
past_pprint_extended_metainfo (FILE* out, s_past_node_t* root,
			       past_metainfo_fun_t mprint,
			       past_pprint_extensions_fun_t past_pprint_ext);

END_C_DECLS


#endif // PAST_PPRINT_H
