/*
 * symbols.h: This file is part of the PAST project.
 *
 * PAST: the PoCC Abstract Syntax Tree
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 *
 */
#ifndef PAST_SYMBOLS_H
# define PAST_SYMBOLS_H

# include <past/common.h>

BEGIN_C_DECLS

enum symbol_type
{
  past_float,
  past_double,
  past_vfloat,
  past_vdouble,
  past_array,
  past_scalar,
  past_pointer,
  past_unknown
};
typedef enum symbol_type e_symbol_type_t;

struct symbol_t
{
  e_symbol_type_t      	type;
  int			is_char_data; // 1 if void* data is indeed char*
				      // data (imply strdup), 0 otherwise
  void*			data;
  int			num_refs;
  int			is_attached_to_table;
  struct symbol_t*	next;
  struct symbol_t*	prev;
};
typedef struct symbol_t s_symbol_t;

struct symbol_table_t
{
  s_symbol_t*	symbols;
};
typedef struct symbol_table_t s_symbol_table_t;

/**
 *
 *
 */
extern
s_symbol_t*
symbol_malloc ();

/**
 *
 *
 */
extern
s_symbol_table_t*
symbol_table_malloc ();

/**
 *
 *
 */
extern
void
symbol_free (s_symbol_t* symbol);

/**
 *
 *
 */
extern
void
symbol_table_free (s_symbol_table_t* table);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_create (e_symbol_type_t type, int is_char_data, void* data);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_add (s_symbol_table_t* table, s_symbol_t* symbol);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_add_from_data (s_symbol_table_t* table, void* data);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_add_from_char (s_symbol_table_t* table, const char* data);

/**
 *
 *
 */
extern
void
symbol_remove (s_symbol_table_t* table, s_symbol_t* symbol);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_find (s_symbol_table_t* table, s_symbol_t* symbol);

/**
 *
 *
 */
extern
int
symbol_equal (s_symbol_t* s1, s_symbol_t* s2);

/**
 *
 *
 */
extern
int
symbol_type_equal (s_symbol_t* s1, s_symbol_t* s2);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_find_from_data (s_symbol_table_t* table, void* data);

/**
 *
 *
 */
extern
s_symbol_t*
symbol_find_from_char (s_symbol_table_t* table, char* data);



END_C_DECLS


#endif // PAST_SYMBOLS_H
