/*
 * options.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006,2007,2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_OPTIONS_H
# define LETSEE_OPTIONS_H

# include <stdio.h>
# include <letsee/common.h>
# include <fm/vector.h>
# include <fm/solver.h>
# include <fm/piptools.h>

# define LS_TYPE_GLOBAL 1
# define LS_TYPE_MIXED  2
# define LS_TYPE_LOCAL  3
# define LS_TYPE_OSPACE 4
# define LS_TYPE_MULTI  5
# define LS_TYPE_FUSION 6
# define LS_TYPE_FD	7
# define LS_TYPE_FS	8
# define LS_TYPE_FS2	9

# define LS_HEURISTIC_EXHAUST  1
# define LS_HEURISTIC_H1       2
# define LS_HEURISTIC_R1       3
# define LS_HEURISTIC_R2       4
# define LS_HEURISTIC_R3       5
# define LS_HEURISTIC_R1M      6
# define LS_HEURISTIC_H1M      7
# define LS_HEURISTIC_E1M      8
# define LS_HEURISTIC_M1       9
# define LS_HEURISTIC_SKIP    10
# define LS_HEURISTIC_PLUTO   11
# define LS_HEURISTIC_PLUTOM  12
# define LS_HEURISTIC_PLUTOM1 13
# define LS_HEURISTIC_PLUTOM2 14
# define LS_HEURISTIC_PLUTOCC 15
# define LS_HEURISTIC_PLUTOV2 16
# define LS_HEURISTIC_RANDOM  17
# define LS_HEURISTIC_DH      18

# define LS_HEURISTIC_M1_SCHEME_ITER		1
# define LS_HEURISTIC_M1_SCHEME_ITERPARAM	2
# define LS_HEURISTIC_M1_SCHEME_FULL		3
# define LS_HEURISTIC_M1_SCHEME_NONE		4

# define LS_HEURISTIC_MAX_SCHEME_SIZE		64

# define LS_BACKTRACK_DISABLE  0
# define LS_BACKTRACK_ENABLE   1

BEGIN_C_DECLS

struct s_ls_options
{
  FILE*			in_file;
  FILE*			out_file;
  int			has_out_file;
  z_type_t		lb;
  z_type_t		Ub;
  z_type_t		plb;
  z_type_t		pUb;
  z_type_t		clb;
  z_type_t		cUb;
  int			fm_mode;
  int			verbose;
  int			create_schedfiles;
  char*			transfo_dir;
  int			type;
  int			normalize_space;
  int			heuristic;
  char*			input_file;
  char*			compile_line;
  int			thresold;
  int			rtries;
  int			noredundancy_solver;
  char*			load_file;
  int			tile;
  int			tile_factor;
  s_fm_vector_t*	vector;
  s_fm_vector_t*	vector2;
  int			backtrack_mode;
  int			traffic_order;
  int*			scheme_m1;
  int			maxscale_solver;
  int			prune_oset;
  void*			pocc_utils;
};


typedef struct s_ls_options s_ls_options_t;

extern
s_ls_options_t*
ls_options_malloc ();

extern
void
ls_options_free (s_ls_options_t* options);

extern
void
ls_options_print (FILE* stream, s_ls_options_t* options);


END_C_DECLS


#endif // LETSEE_OPTIONS_H
