/*
 * space.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_SPACE_H
# define LETSEE_SPACE_H

# include <letsee/common.h>
# include <letsee/options.h>
# include <fm/system.h>
# include <fm/solution.h>
# include <fm/compsol.h>
# include <candl/candl.h>


BEGIN_C_DECLS

struct s_ls_space
{
  unsigned long long int	size;
  unsigned			dimension;	/* dimension of the schedule */
  s_fm_solution_t*		polyhedron;
  s_fm_solution_t**		u_polyhedron;	/* Union of polyhedra */
  s_fm_compsol_t**		u_compacted;
  /// FIXME: Temporarily extend the space structure.
  CandlProgram*			program;
  CandlDependence*		dependences;
};


typedef struct s_ls_space s_ls_space_t;

extern
s_ls_space_t*
ls_space_alloc ();

extern
void
ls_space_free (s_ls_space_t* space);


extern
s_ls_space_t*
ls_space (CandlProgram* program,
	  CandlDependence* dependences,
	  s_ls_options_t* options);


END_C_DECLS


#endif // LETSEE_SPACE_H
