#! /bin/sh


## Some useful options.
#
## Set cloog binary.
cloog="cloog"
## Set letsee binary.
letsee="src/letsee"
## Set the options to provide to letsee.
letsee_opts="-t multi -s"
## Set directory where transformations are.
transfo_path="transformations"
## Set GCC (optimization) options.
gcc_opt="-O2"
## Set directory where results are to be stored.
results_directory="$transfo_path"
## Set the path to eventtoname
event_to_name="./src/scripts/eventtoname"
## set the event list to monitor.
eventlist="src/scripts/eventlist.p4xeon.short"


# Test if enough parameters were given.
if [ $# -ne 8 ]; then
   echo "Usage: tester.sh lb Ub plb pUb clb cUb compilation_line FILE.candl"
   echo "Compilation line should contain -DPARVALXXX=YYY where XXX is the"
   echo "number of the parameter, and YYY its value."
   exit 1;
fi

## Retrieve variables from environment. If the variable is unset, use
## default values at the top of this script.
if [ -z "$GCC" ]; then
    GCC=gcc;
fi
if [ -z "$GCC_OPT" ]; then
    GCC_OPT="$gcc_opt";
fi
if [ -z "$CLOOG" ]; then
    CLOOG="$cloog";
fi
if [ -z "$LETSEE" ]; then
    LETSEE="$letsee";
fi
if [ -z "$LETSEE_OPTS" ]; then
    LETSEE_OPTS="$letsee_opts";
fi
if [ -z "$TRANSFO_PATH" ]; then
    TRANSFO_PATH="$transfo_path";
fi
if [ -z "$RESULTS_DIRECTORY" ]; then
    RESULTS_DIRECTORY="$results_directory";
fi
if [ -z "$EVENTLIST" ]; then
    EVENTLIST="$eventlist";
fi


lb="$1";
Ub="$2";
plb="$3";
pUb="$4";
clb="$5";
cUb="$6";
compile_line="$7";
shift 7;


function scale_doc()
{
    IFS='
'
    FFS="";
    dep="$1";
    myval="$2";
    myscale="$3";
    while read n; do
	theval=`echo "$n" | cut -d ' ' -f "$myval"`;
	thevals=`echo "scale=2;$theval / $myscale" | bc -l`;
	newl=`echo "$n" | sed -e "s/ $theval / $thevals /g"`;
	FFS="$FFS$newl$IFS";
    done < $dep;
    echo -n "$FFS" > $dep;
}

function eventtoname()
{
    eventlist="$EVENTLIST"
    IFS='
'
    while read n; do
	if [ "$n" = "__EVENTLIST__" ]; then
	    FC="$FC"`cat $eventlist`;
	else
	    FC="$FC$n";
	fi
	FC="$FC$IFS";
    done < "$event_to_name.c"
    echo "$FC" > "$event_to_name.tmp.c"
    out=`gcc -O2 -lpapi "$event_to_name.tmp.c" -o $event_to_name`
    #rm -f "$event_to_name.tmp.c"
}


## Loop on each argument.
while [ $# -ne 0 ]; do
    # Create the temporary results files.
    pattern=`basename $1`;
    pattern=${pattern%.candl}
    pattern="$RESULTS_DIRECTORY/letsee.$pattern.XXXXXX"
    out_file=`mktemp ${pattern}`
    plot_file="$out_file.dat"

    FILENAME=${1%.candl};
    
    echo -e "\033[33m=> Testing $FILENAME\033[0m";
    echo -e "\033[33m=  Test parameters: "
    echo -e "   tlb: $lb tUb: $Ub";
    echo -e "   plb: $plb pUb: $pUb";
    echo -e "   clb: $clb cUb: $cUb";
    echo -e "   Compilation line: $compile_line\033[0m";
    echo -e "";
    echo -e "\033[32mStarting transformations generation...\033[0m";
    # Lanch letsee.
    t=`make clean-transfo`
    time ./$LETSEE $LETSEE_OPTS "$1" -a "$lb" -b "$Ub" -c "$plb" -d "$pUb" -e "$clb" -f "$cUb" -v > $out_file
    cat $out_file

    echo -e "\033[32mStarting code generation and execution...\033[0m";
    # Compile and run the original code.
    orig_target=${FILENAME##*/}
    echo -e "\033[33mProcessing original code\033[0m" >> $out_file;
    #cp $FILENAME.cloog $TRANSFO_PATH
    #CLOOG="$CLOOG" EVENTLIST="$EVENTLIST" src/scripts/cloog2test/cloog2test2 -sctp "$FILENAME.program"    "$TRANSFO_PATH/$orig_target.cloog";
#   $GCC "$GCC_OPT" -lm "$TRANSFO_PATH/$orig_target.c" -o "$TRANSFO_PATH/$orig_target" &>/dev/null;
    $compile_line -lm -DLETSEE_PAPI -lpapi "$TRANSFO_PATH/$orig_target.c" -o "$TRANSFO_PATH/$orig_target" #&>/dev/null;
    output_orig_prg=`./$TRANSFO_PATH/$orig_target`;
    echo "$output_orig_prg" >> $out_file;
    # Print progress bar.
    echo -n ".";

    count=0;
    # Generate code from the result of letsee's computation.
    for i in `find $TRANSFO_PATH -name "transformation*.cloog"`; do
	target=${i%.cloog};
	/bin/echo -e "\033[33mProcessing $target\033[0m" >> $out_file;
	CLOOG=$CLOOG EVENTLIST="$EVENTLIST" src/scripts/cloog2test/cloog2test2 -sctp "$FILENAME.program" "$i";

        # Compile and run test codes.
#	$GCC "$GCC_OPT" -lm "$target.c" -o "$target" &>/dev/null;
	$compile_line -lm -DLETSEE_PAPI -lpapi "$target.c" -o "$target" &>/dev/null;
	output_prg=`./$target`;
	if [ $? -ne 0 ]; then
	    echo -e "\033[31m$target has segfault-ed\033[0m";
	    rm -f $target.output
	    exit 1;
	fi
	# Get informations and fill the GNUPlot data file.
	prg_idx=`echo "$target" | sed "s/.*_\(.*\)/\1/g"`;
	prg_cycles=`echo "$output_prg" | grep Cycles | cut -d : -f 2`;
	prg_values=`echo "$output_prg" | grep Values | cut -d : -f 2`;
	echo "$prg_idx$prg_cycles$prg_values" >> $plot_file;
	echo "$output_prg" >> $out_file;
	count=$(($count + 1));
	# Check if there is no difference between program output and
	# original code output.
	the_diff=`diff ./$target.output ./$TRANSFO_PATH/$orig_target.output`;
	if ! [ -z "$the_diff" ]; then
	    echo -e "\033[31m$target has difference in output\033[0m";
	else
	    rm -f $target.output
	fi
	# Print progress bar.
	echo -n ".";
    done

    echo;
    
#exit 12;

    # Add the original code performance to the GNUPlot data file.
    orig_cycles=`echo "$output_orig_prg" | grep Cycles | cut -d : -f 2`;
    orig_values=`echo "$output_orig_prg" | grep Values | cut -d : -f 2`;
    orig_idx=$count;
    echo "# Original code is at position $count" >> $plot_file;
    echo "$count$orig_cycles$orig_values" >> $plot_file;

    # Rank the best transformations.
    count=1;
    completed=0;
    min="";
    for i in `grep Cycles $out_file | cut -d : -f 2 | sort -n`; do
       res=`grep -C 1 "$i" $out_file | grep "Processing" | \
                                      sed -e "s/Processing//g"`;
       orig=`echo "$res" | grep original`;
       if [ $count -le 10 ] && [ -z "$orig" ]; then
	   if [ -z "$min" ]; then min="$i"; fi;
           echo -e "\033[33m- Ranked $count:\t$res\033[33m\t $i cycles\033[0m";
       fi
       if ! [ -z "$orig" ]; then 
         filen=`basename $FILENAME`;
         echo -e "\033[33m- Ranked $count:\t Original code ($filen)\t\t $i cycles\033[0m";
	 completed=1;
       fi
       count=$(($count + 1));
       # Stop when interesting informations were retrieved.
       if [ "$completed" -eq 1 ] && [ "$count" -gt 10 ]; then 
	   break; 
       fi
    done
#set -x
    
    ## Reproduce the original code in the file, to emphasize it.
    countit=$orig_idx
    it=1
    it_orig_max=`cat $plot_file | wc -l `;
    it_orig_max=$(($it_orig_max / 20 + 1));
    if [ $it_orig_max -le 3 ]; then it_orig_max=3; fi;
#    cat "$plot_file" > $plot_file.toto.tmp;
#    while [ $it -ne 11 ]; do
#	countit=$(($count + $it));
#	echo "$countit$orig_cycles$orig_values" >> $plot_file.toto.tmp;
#	it=$(($it + 1));
#    done
    while [ $it -ne $it_orig_max ]; do
	countit=$(($orig_idx + $it));
	echo "$countit$orig_cycles$orig_values" >> $plot_file;
	it=$(($it + 1));
    done


     # Execute the GNUPlot script to generate the charts (in pdf).
     min_idx=`grep "$min" "$plot_file" | cut -d ' ' -f 1`;
     pt=`grep -v "#" "$plot_file" | wc -l`
     pt=$(($pt - 1));
     ## Prepare the sorted file.
     idxl=0; 
     for i in `cat $plot_file | grep -v "#" | cut -d ' ' -f 2 | sort -n`; do 
        l=`grep "$i" $plot_file | head -n 1 | sed -e 's/[0-9]\+[ ]\+\([0-9]\+.*\)/\1 /g'`; 
	echo "$idxl" "$l";  
	idxl=$(($idxl + 1)); 
     done > $plot_file.tmp
#     echo "plot.tmp"
#     cat -e $plot_file.tmp
#     echo "plot"
#     cat $plot_file
     orig_sorted_idx=`grep "$orig_cycles" "$plot_file.tmp" | head -n 1 | cut -d ' ' -f 1`
#     echo "X $orig_sorted_idx X"
     orig_sorted_idx_ten=$(($orig_sorted_idx + $it_orig_max - 1));
     max=`tail -n 1 "$plot_file.tmp" | cut -d ' ' -f 2`
     #grep -v "#" "$plot_file" | cut -d ' ' -f 3  | sort -n > $plot_file.tmp
     echo "set term post enh \"Helvetica\" 24; set output \"$out_file.ps\"; \
 	set nokey ; set xlabel \"Transfo.\"; set ylabel \"Cycles\"; \
 	set title \"$orig_target\"; set autoscale; \
 	set label \"Original\" at $orig_idx,$orig_cycles ;\
 	set label \"Best\" at $min_idx,$min ;\
 	plot \"$plot_file.tmp\" using 1:2 " | gnuplot ;
     ps2pdf $out_file.ps $out_file.pdf;
     rm -f $out_file.ps;

     ## Define the plot command.
     plot_cmd="\"$plot_file.tmp\" u 1:2 w lines t \"Cycles\"";
     min_c=`cut -d ' ' -f 2 "$plot_file.tmp" | sort -n | head -n 1`;
     max_c=`cut -d ' ' -f 2 "$plot_file.tmp" | sort -n | tail -n 1`;
     cnt=3;
     eventtoname;
     out=`$event_to_name`;
     IFS='
'
     for n in `echo "$out"`; do # | while read n; do
      k=`echo "$n" | sed -e "s/PAPI_\(.*\)/\1/g" | sed -e "s/_/-/g"`
      val=$cnt;
      min_l=`cut -d ' ' -f "$val" "$plot_file.tmp" | sort -n | head -n 1`
      max_l=`cut -d ' ' -f "$val" "$plot_file.tmp" | sort -n | tail -n 1`
      scale=`echo "$max_l / $max_c" | bc -l`;
      if [ "$scale" = "0" ]; then scale=1; fi;
      scale_doc "$plot_file.tmp" "$val" "$scale";
      plot_cmd="$plot_cmd, \"$plot_file.tmp\" u 1:$cnt w \
		lines t \"$k\"";
      cnt=$(($cnt + 1));
     done;

     ## Print full graph.
     echo "set term post color enh \"Helvetica\" 24; \
	set output \"$out_file.ps\"; \
	set key below;\
	set border 1;\
	set xtics nomirror; set ytics nomirror;\
 	set title \"$orig_target\"; set autoscale x; \
        set arrow from $orig_sorted_idx,0 to $orig_sorted_idx,$max nohead lt -1 lw 1;\
        set arrow from $orig_sorted_idx_ten,0 to $orig_sorted_idx_ten,$max nohead lt -1 lw 1;\
 	plot $plot_cmd" | gnuplot;
     ps2pdf $out_file.ps $out_file.papi.pdf;
     rm -f $out_file.ps;

     rm -f $out_file.tmp;
     echo "set term post enh \"Helvetica\" 24; set output \"$out_file.ps\"; \
	set nokey ; set xlabel \"Transfo. ID\"; set ylabel \"Cycles (M)\"; \
 	set title \"$orig_target\"; set autoscale; \
 	set label \"Original\" at $orig_idx,$orig_cycles ;\
        set arrow from 0,$orig_cycles to $pt,$orig_cycles nohead lt -1 lw 1.2;\
 	plot \"$plot_file\" using 1:2 " | gnuplot ;
     ps2pdf $out_file.ps $out_file.raw.pdf;
     rm -f $out_file.ps;



    # Echoing results filename.
    echo -e "\033[33mResults are stored in template $out_file (.dat, .pdf).\033[0m";

    # Echoing GCC version.
    echo -e "\033[36mGCC version used: \033[0m";
    $GCC --version

    echo -e "\033[32mAll done for input $1.\033[0m";
    
    shift 1;
done
