/*
 * stack.h: This file is part of the IR-Converter project.
 *
 * IR-Converter: a library to convert PAST to ScopLib
 *
 * Copyright (C) 2011 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 *
 */
#ifndef IRCONVERTER_STACK_H
# define IRCONVERTER_STACK_H

BEGIN_C_DECLS

struct s_stack
{
  void*			data;
  struct s_stack*	next;
};
typedef struct s_stack s_stack_t;


extern
void
stack_push (s_stack_t** stack, void* data);

extern
void*
stack_pop (s_stack_t** stack);

extern
int
stack_size (s_stack_t** stack);

extern
s_stack_t*
stack_contains (s_stack_t** stack, void* data);

extern
void
stack_free (s_stack_t** stack);


END_C_DECLS


#endif // IRCONVERTER_STACK_H
