#!/usr/bin/perl -w

# Gabriel L. Somlo - 2004,2005

# QueryTracker is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
#
# QueryTracker is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with QueryTracker; see the file COPYING.  If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.  


use strict 'refs';
use lib '..';
use CGI qw(:standard);
use CGI::Carp qw/fatalsToBrowser/;

my $megabytes = 6;
$CGI::POST_MAX = 1024 * 1024 * $megabytes;	# max. post size


# all this crap should really be in one consistent location!
my $qfile="/home/QueryTracker/Query.list";
my $vardir="/home/QueryTracker/var";
my $pretrn = "_pretrn";	# pre_train directory name
my $mutex= "$vardir/QueryTracker.lock";


# get remote user
my $user = $ENV{'REMOTE_USER'};


# get list of queries for this user:
my @qids = ();
my @qterms = ();
system( "lockfile $mutex" );	# lock exclusive access to query file
open( QRY, "grep ^$user\. $qfile |" ) || die( "Can't open query file:$!" );
while ( <QRY> ) {
  my ($u_id, $terms, $rest) = split( /:/ );
  my $id = (split(/\./, $u_id))[1];
  $terms =~ s/\+/ /g;
  push( @qids, $id );
  push( @qterms, $terms );
}
close( QRY );
system( "rm -f $mutex" );	# unlock exclusive access to query file


# start page
print header();
print start_html("QueryTracker: user=$user: Train Profile");
print h1("QueryTracker: user=$user: Train Profile"), hr;


# Process the form if stuff was submitted
if ( my $file = param('filename') ) {

  if ( my $qsel = param('qsel') ) {

    my $tmpfile=tmpFileName($file);

    # original, preload, and preload/pretrain directories
    my $qdir="$vardir/$user.$qsel";
    my $pdir="$vardir/preload-$user.$qsel";
    my $tdir = "$pdir/$pretrn";

    # lock exclusive access to query file
    system( "lockfile $mutex" );

    # make sure preload directory exists, and clone from regular if not
    unless ( -d $pdir ) {
      mkdir( $pdir, 0700 );
      if ( -d $qdir ) { # clone only if regular directory already exists !
        system( "(cd $qdir; tar cf - *) | (cd $pdir; tar xf -)" );
      }
      # make sure the $pdir/$pretrn directory exists in the preload version
      mkdir( $tdir, 0700 ) unless ( -d $tdir );
      # add entry to $qfile
      my $qline=qx/grep ^$user\.$qsel: $qfile/;
      chomp( $qline );
      system( "echo preload-$qline >> $qfile" );
    }


    if ( -f "$tdir/$file" ) {
      print "<font color=red>A file named $file was already submitted for", br,
            "query $qsel ! Please pick a different name !</font>", br, hr;
    } else {
      system "cp $tmpfile $tdir/$file";
      print '<font color=blue>File upload successful -- Thank You !</font>',
            br, hr;
    }

    close $file;

    # unlock exclusive access to query file
    system( "rm -f $mutex" );

  } else {
    print '<font color=red>No Query selected -- Please try again !</font>',
          br, hr;
  }

}

if ( cgi_error() eq "413 Request entity too large" ) {
  print "<font color=red>File size limit ($megabytes MBytes) exceeded -- ",
        "Please try again !</font>", br, hr;
} elsif ( cgi_error() ) {
  print "<font color=red>Unexpected error encountered (", cgi_error(), ") -- ",
        "Please notify <b>somlo (at) cs dot colostate dot edu</b></font>",
        br, hr;
}

# print generic blurb, and form
print 'This page allows you to train your QueryTracker query profile by', br,
      'uploading your own examples of relevant documents', br,
      '(ASCII, HTML, PostScript, or PDF).', p;

print start_multipart_form();

print 'Pick the query you wish to train:', br, '<table border>',
      '<tr><td>Query ID:</td><td>Query Terms:</td><td>Select</td></tr>';
for my $i ( 0..$#qids ) {
  print "<tr><td>$qids[$i]</td><td>$qterms[$i]</td>",
     "<td align=center><input type=radio name=qsel value=$qids[$i]></td></tr>";
}
print '</table>', p;

print "Enter file to upload:", filefield('filename','',45), p;

print submit('submit','Upload File'),reset,
    endform;

print hr,
    a({href=>"index.cgi"},"Home"),
    end_html;

