#!/usr/bin/perl -w

# Gabriel L. Somlo - 2004,2005

# QueryTracker is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
#
# QueryTracker is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with QueryTracker; see the file COPYING.  If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.  


my %by_url = ();

while ( <> ) {
  chomp;
  my ($url, $fname) = split;
  if ( defined($by_url{$url}) ) {
    $by_url{$url} .= "-$fname";
  } else {
    $by_url{$url} = $fname;
  }
}
# sort insures keys are always displayed in a predictable way
# if a random shuffle is needed, we do that separately with unsort.ksh !
for my $k ( sort keys(%by_url) ) {
  print( "$k $by_url{$k}\n" );
}
